import { z } from 'zod';
/** Based on input base command schema it returns the current type string literal */
export declare function getCommandTypeOfSchema<T extends string>(schema: BaseCommandSchema<T>): any;
/** The schema used here only for get correct zod schema type including required literal property type. */
declare const createBaseCommandSchema: <T extends string>(type: T) => z.ZodObject<{
    type: z.ZodLiteral<T>;
}, "strict", z.ZodTypeAny, { [k_1 in keyof z.objectUtil.addQuestionMarks<z.baseObjectOutputType<{
    type: z.ZodLiteral<T>;
}>, undefined extends T ? never : "type">]: z.objectUtil.addQuestionMarks<z.baseObjectOutputType<{
    type: z.ZodLiteral<T>;
}>, undefined extends T ? never : "type">[k_1]; }, { [k_2 in keyof z.baseObjectInputType<{
    type: z.ZodLiteral<T>;
}>]: z.baseObjectInputType<{
    type: z.ZodLiteral<T>;
}>[k_2]; }>;
/**
 * This is the basic command base schema interface containing only the type property.
 * It's the basic definition of the command and it's used to create more complex command schemas.
 */
type BasicActionCommandSchema<T extends string> = ReturnType<typeof createBaseCommandSchema<T>>;
/**
 * This is a complex command schema for even discriminated unions.
 * But always it has to contain the type property.
 */
export type BaseCommandSchema<T extends string = string> = BasicActionCommandSchema<T> | z.ZodDiscriminatedUnion<any, BasicActionCommandSchema<T>[]>;
export declare function registerCommandSchema<T extends string>(schema: BaseCommandSchema<T>): void;
export declare function getCommandSchema(type: string): BaseCommandSchema | null;
export declare function getAllCommandSchemas(): BaseCommandSchema[];
export {};
