import { z } from 'zod';
/**
 * Create white label settings and its UI theme
 */
export declare const CreateWhiteLabelSettingsWithUITheme = "WhiteLabelSettings.CreateWhiteLabelSettingsWithUITheme";
export declare const CreateWhiteLabelSettingsWithUIThemeSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"WhiteLabelSettings.CreateWhiteLabelSettingsWithUITheme">;
    whiteLabelSettings: z.ZodObject<{
        uid: z.ZodString;
        customDomain: z.ZodOptional<z.ZodEffects<z.ZodString, string, string>>;
        emailFooter: z.ZodString;
        notificationEmailAddress: z.ZodString;
        notificationEmailName: z.ZodString;
        pageTitle: z.ZodString;
        disabledFeatures: z.ZodOptional<z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Feature/FeatureFlag").FeatureFlag>, "many">>;
        disabledEmailTypes: z.ZodOptional<z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Email/EmailType").EmailType>, "many">>;
        emailTemplateType: z.ZodOptional<z.ZodString>;
        privacyPolicyUrl: z.ZodOptional<z.ZodString>;
        auth0Config: z.ZodOptional<z.ZodObject<{
            domain: z.ZodString;
            clientId: z.ZodString;
            organizationDomain: z.ZodOptional<z.ZodString>;
            organizationClientId: z.ZodOptional<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            domain: string;
            clientId: string;
            organizationDomain?: string | undefined;
            organizationClientId?: string | undefined;
        }, {
            domain: string;
            clientId: string;
            organizationDomain?: string | undefined;
            organizationClientId?: string | undefined;
        }>>;
    }, "strict", z.ZodTypeAny, {
        uid: string;
        emailFooter: string;
        notificationEmailAddress: string;
        notificationEmailName: string;
        pageTitle: string;
        customDomain?: string | undefined;
        disabledFeatures?: import("@signageos/common-types/dist/Feature/FeatureFlag").FeatureFlag[] | undefined;
        disabledEmailTypes?: import("@signageos/common-types/dist/Email/EmailType").EmailType[] | undefined;
        emailTemplateType?: string | undefined;
        privacyPolicyUrl?: string | undefined;
        auth0Config?: {
            domain: string;
            clientId: string;
            organizationDomain?: string | undefined;
            organizationClientId?: string | undefined;
        } | undefined;
    }, {
        uid: string;
        emailFooter: string;
        notificationEmailAddress: string;
        notificationEmailName: string;
        pageTitle: string;
        customDomain?: string | undefined;
        disabledFeatures?: import("@signageos/common-types/dist/Feature/FeatureFlag").FeatureFlag[] | undefined;
        disabledEmailTypes?: import("@signageos/common-types/dist/Email/EmailType").EmailType[] | undefined;
        emailTemplateType?: string | undefined;
        privacyPolicyUrl?: string | undefined;
        auth0Config?: {
            domain: string;
            clientId: string;
            organizationDomain?: string | undefined;
            organizationClientId?: string | undefined;
        } | undefined;
    }>;
    uiTheme: z.ZodObject<{
        uid: z.ZodString;
        logo: z.ZodString;
        topBarBackgroundColor1: z.ZodEffects<z.ZodString, string, string>;
        topBarBackgroundColor2: z.ZodEffects<z.ZodString, string, string>;
        tabsCardActiveColor: z.ZodEffects<z.ZodString, string, string>;
        tabsCardActiveBackground: z.ZodEffects<z.ZodString, string, string>;
        btnPrimaryColor: z.ZodEffects<z.ZodString, string, string>;
        btnPrimaryBackground: z.ZodEffects<z.ZodString, string, string>;
        menuItemColor: z.ZodEffects<z.ZodString, string, string>;
        menuItemHoverBackground: z.ZodEffects<z.ZodString, string, string>;
        menuItemActiveBackground: z.ZodEffects<z.ZodString, string, string>;
        hideMenuButtonColor: z.ZodEffects<z.ZodString, string, string>;
        textColor: z.ZodEffects<z.ZodString, string, string>;
        cardTitleColor: z.ZodEffects<z.ZodString, string, string>;
        favicon: z.ZodOptional<z.ZodString>;
        logoSmall: z.ZodOptional<z.ZodString>;
        layout: z.ZodOptional<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Layout/LayoutType").LayoutType>>;
    }, "strict", z.ZodTypeAny, {
        uid: string;
        logo: string;
        topBarBackgroundColor1: string;
        topBarBackgroundColor2: string;
        tabsCardActiveColor: string;
        tabsCardActiveBackground: string;
        btnPrimaryColor: string;
        btnPrimaryBackground: string;
        menuItemColor: string;
        menuItemHoverBackground: string;
        menuItemActiveBackground: string;
        hideMenuButtonColor: string;
        textColor: string;
        cardTitleColor: string;
        favicon?: string | undefined;
        logoSmall?: string | undefined;
        layout?: import("@signageos/common-types/dist/Layout/LayoutType").LayoutType | undefined;
    }, {
        uid: string;
        logo: string;
        topBarBackgroundColor1: string;
        topBarBackgroundColor2: string;
        tabsCardActiveColor: string;
        tabsCardActiveBackground: string;
        btnPrimaryColor: string;
        btnPrimaryBackground: string;
        menuItemColor: string;
        menuItemHoverBackground: string;
        menuItemActiveBackground: string;
        hideMenuButtonColor: string;
        textColor: string;
        cardTitleColor: string;
        favicon?: string | undefined;
        logoSmall?: string | undefined;
        layout?: import("@signageos/common-types/dist/Layout/LayoutType").LayoutType | undefined;
    }>;
}, "strict", z.ZodTypeAny, {
    type: "WhiteLabelSettings.CreateWhiteLabelSettingsWithUITheme";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    whiteLabelSettings: {
        uid: string;
        emailFooter: string;
        notificationEmailAddress: string;
        notificationEmailName: string;
        pageTitle: string;
        customDomain?: string | undefined;
        disabledFeatures?: import("@signageos/common-types/dist/Feature/FeatureFlag").FeatureFlag[] | undefined;
        disabledEmailTypes?: import("@signageos/common-types/dist/Email/EmailType").EmailType[] | undefined;
        emailTemplateType?: string | undefined;
        privacyPolicyUrl?: string | undefined;
        auth0Config?: {
            domain: string;
            clientId: string;
            organizationDomain?: string | undefined;
            organizationClientId?: string | undefined;
        } | undefined;
    };
    uiTheme: {
        uid: string;
        logo: string;
        topBarBackgroundColor1: string;
        topBarBackgroundColor2: string;
        tabsCardActiveColor: string;
        tabsCardActiveBackground: string;
        btnPrimaryColor: string;
        btnPrimaryBackground: string;
        menuItemColor: string;
        menuItemHoverBackground: string;
        menuItemActiveBackground: string;
        hideMenuButtonColor: string;
        textColor: string;
        cardTitleColor: string;
        favicon?: string | undefined;
        logoSmall?: string | undefined;
        layout?: import("@signageos/common-types/dist/Layout/LayoutType").LayoutType | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "WhiteLabelSettings.CreateWhiteLabelSettingsWithUITheme";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    whiteLabelSettings: {
        uid: string;
        emailFooter: string;
        notificationEmailAddress: string;
        notificationEmailName: string;
        pageTitle: string;
        customDomain?: string | undefined;
        disabledFeatures?: import("@signageos/common-types/dist/Feature/FeatureFlag").FeatureFlag[] | undefined;
        disabledEmailTypes?: import("@signageos/common-types/dist/Email/EmailType").EmailType[] | undefined;
        emailTemplateType?: string | undefined;
        privacyPolicyUrl?: string | undefined;
        auth0Config?: {
            domain: string;
            clientId: string;
            organizationDomain?: string | undefined;
            organizationClientId?: string | undefined;
        } | undefined;
    };
    uiTheme: {
        uid: string;
        logo: string;
        topBarBackgroundColor1: string;
        topBarBackgroundColor2: string;
        tabsCardActiveColor: string;
        tabsCardActiveBackground: string;
        btnPrimaryColor: string;
        btnPrimaryBackground: string;
        menuItemColor: string;
        menuItemHoverBackground: string;
        menuItemActiveBackground: string;
        hideMenuButtonColor: string;
        textColor: string;
        cardTitleColor: string;
        favicon?: string | undefined;
        logoSmall?: string | undefined;
        layout?: import("@signageos/common-types/dist/Layout/LayoutType").LayoutType | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type CreateWhiteLabelSettingsWithUITheme = z.infer<typeof CreateWhiteLabelSettingsWithUIThemeSchema>;
export declare const CreateWhiteLabelSettingsWithUIThemeFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    whiteLabelSettings: import("../types").ObjectRecursiveDifference<{
        uid: string;
        emailFooter: string;
        notificationEmailAddress: string;
        notificationEmailName: string;
        pageTitle: string;
        customDomain?: string | undefined;
        disabledFeatures?: import("@signageos/common-types/dist/Feature/FeatureFlag").FeatureFlag[] | undefined;
        disabledEmailTypes?: import("@signageos/common-types/dist/Email/EmailType").EmailType[] | undefined;
        emailTemplateType?: string | undefined;
        privacyPolicyUrl?: string | undefined;
        auth0Config?: {
            domain: string;
            clientId: string;
            organizationDomain?: string | undefined;
            organizationClientId?: string | undefined;
        } | undefined;
    }, {
        uid: () => string;
    }, Function>;
    uiTheme: import("../types").ObjectRecursiveDifference<{
        uid: string;
        logo: string;
        topBarBackgroundColor1: string;
        topBarBackgroundColor2: string;
        tabsCardActiveColor: string;
        tabsCardActiveBackground: string;
        btnPrimaryColor: string;
        btnPrimaryBackground: string;
        menuItemColor: string;
        menuItemHoverBackground: string;
        menuItemActiveBackground: string;
        hideMenuButtonColor: string;
        textColor: string;
        cardTitleColor: string;
        favicon?: string | undefined;
        logoSmall?: string | undefined;
        layout?: import("@signageos/common-types/dist/Layout/LayoutType").LayoutType | undefined;
    }, {
        uid: () => string;
    }, Function>;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "WhiteLabelSettings.CreateWhiteLabelSettingsWithUITheme";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    whiteLabelSettings: {
        uid: string;
        emailFooter: string;
        notificationEmailAddress: string;
        notificationEmailName: string;
        pageTitle: string;
        customDomain?: string | undefined;
        disabledFeatures?: import("@signageos/common-types/dist/Feature/FeatureFlag").FeatureFlag[] | undefined;
        disabledEmailTypes?: import("@signageos/common-types/dist/Email/EmailType").EmailType[] | undefined;
        emailTemplateType?: string | undefined;
        privacyPolicyUrl?: string | undefined;
        auth0Config?: {
            domain: string;
            clientId: string;
            organizationDomain?: string | undefined;
            organizationClientId?: string | undefined;
        } | undefined;
    };
    uiTheme: {
        uid: string;
        logo: string;
        topBarBackgroundColor1: string;
        topBarBackgroundColor2: string;
        tabsCardActiveColor: string;
        tabsCardActiveBackground: string;
        btnPrimaryColor: string;
        btnPrimaryBackground: string;
        menuItemColor: string;
        menuItemHoverBackground: string;
        menuItemActiveBackground: string;
        hideMenuButtonColor: string;
        textColor: string;
        cardTitleColor: string;
        favicon?: string | undefined;
        logoSmall?: string | undefined;
        layout?: import("@signageos/common-types/dist/Layout/LayoutType").LayoutType | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    whiteLabelSettings: {
        uid: () => string;
    };
    uiTheme: {
        uid: () => string;
    };
}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"WhiteLabelSettings.CreateWhiteLabelSettingsWithUITheme">;
    whiteLabelSettings: z.ZodObject<{
        uid: z.ZodString;
        customDomain: z.ZodOptional<z.ZodEffects<z.ZodString, string, string>>;
        emailFooter: z.ZodString;
        notificationEmailAddress: z.ZodString;
        notificationEmailName: z.ZodString;
        pageTitle: z.ZodString;
        disabledFeatures: z.ZodOptional<z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Feature/FeatureFlag").FeatureFlag>, "many">>;
        disabledEmailTypes: z.ZodOptional<z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Email/EmailType").EmailType>, "many">>;
        emailTemplateType: z.ZodOptional<z.ZodString>;
        privacyPolicyUrl: z.ZodOptional<z.ZodString>;
        auth0Config: z.ZodOptional<z.ZodObject<{
            domain: z.ZodString;
            clientId: z.ZodString;
            organizationDomain: z.ZodOptional<z.ZodString>;
            organizationClientId: z.ZodOptional<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            domain: string;
            clientId: string;
            organizationDomain?: string | undefined;
            organizationClientId?: string | undefined;
        }, {
            domain: string;
            clientId: string;
            organizationDomain?: string | undefined;
            organizationClientId?: string | undefined;
        }>>;
    }, "strict", z.ZodTypeAny, {
        uid: string;
        emailFooter: string;
        notificationEmailAddress: string;
        notificationEmailName: string;
        pageTitle: string;
        customDomain?: string | undefined;
        disabledFeatures?: import("@signageos/common-types/dist/Feature/FeatureFlag").FeatureFlag[] | undefined;
        disabledEmailTypes?: import("@signageos/common-types/dist/Email/EmailType").EmailType[] | undefined;
        emailTemplateType?: string | undefined;
        privacyPolicyUrl?: string | undefined;
        auth0Config?: {
            domain: string;
            clientId: string;
            organizationDomain?: string | undefined;
            organizationClientId?: string | undefined;
        } | undefined;
    }, {
        uid: string;
        emailFooter: string;
        notificationEmailAddress: string;
        notificationEmailName: string;
        pageTitle: string;
        customDomain?: string | undefined;
        disabledFeatures?: import("@signageos/common-types/dist/Feature/FeatureFlag").FeatureFlag[] | undefined;
        disabledEmailTypes?: import("@signageos/common-types/dist/Email/EmailType").EmailType[] | undefined;
        emailTemplateType?: string | undefined;
        privacyPolicyUrl?: string | undefined;
        auth0Config?: {
            domain: string;
            clientId: string;
            organizationDomain?: string | undefined;
            organizationClientId?: string | undefined;
        } | undefined;
    }>;
    uiTheme: z.ZodObject<{
        uid: z.ZodString;
        logo: z.ZodString;
        topBarBackgroundColor1: z.ZodEffects<z.ZodString, string, string>;
        topBarBackgroundColor2: z.ZodEffects<z.ZodString, string, string>;
        tabsCardActiveColor: z.ZodEffects<z.ZodString, string, string>;
        tabsCardActiveBackground: z.ZodEffects<z.ZodString, string, string>;
        btnPrimaryColor: z.ZodEffects<z.ZodString, string, string>;
        btnPrimaryBackground: z.ZodEffects<z.ZodString, string, string>;
        menuItemColor: z.ZodEffects<z.ZodString, string, string>;
        menuItemHoverBackground: z.ZodEffects<z.ZodString, string, string>;
        menuItemActiveBackground: z.ZodEffects<z.ZodString, string, string>;
        hideMenuButtonColor: z.ZodEffects<z.ZodString, string, string>;
        textColor: z.ZodEffects<z.ZodString, string, string>;
        cardTitleColor: z.ZodEffects<z.ZodString, string, string>;
        favicon: z.ZodOptional<z.ZodString>;
        logoSmall: z.ZodOptional<z.ZodString>;
        layout: z.ZodOptional<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Layout/LayoutType").LayoutType>>;
    }, "strict", z.ZodTypeAny, {
        uid: string;
        logo: string;
        topBarBackgroundColor1: string;
        topBarBackgroundColor2: string;
        tabsCardActiveColor: string;
        tabsCardActiveBackground: string;
        btnPrimaryColor: string;
        btnPrimaryBackground: string;
        menuItemColor: string;
        menuItemHoverBackground: string;
        menuItemActiveBackground: string;
        hideMenuButtonColor: string;
        textColor: string;
        cardTitleColor: string;
        favicon?: string | undefined;
        logoSmall?: string | undefined;
        layout?: import("@signageos/common-types/dist/Layout/LayoutType").LayoutType | undefined;
    }, {
        uid: string;
        logo: string;
        topBarBackgroundColor1: string;
        topBarBackgroundColor2: string;
        tabsCardActiveColor: string;
        tabsCardActiveBackground: string;
        btnPrimaryColor: string;
        btnPrimaryBackground: string;
        menuItemColor: string;
        menuItemHoverBackground: string;
        menuItemActiveBackground: string;
        hideMenuButtonColor: string;
        textColor: string;
        cardTitleColor: string;
        favicon?: string | undefined;
        logoSmall?: string | undefined;
        layout?: import("@signageos/common-types/dist/Layout/LayoutType").LayoutType | undefined;
    }>;
}, "strict", z.ZodTypeAny, {
    type: "WhiteLabelSettings.CreateWhiteLabelSettingsWithUITheme";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    whiteLabelSettings: {
        uid: string;
        emailFooter: string;
        notificationEmailAddress: string;
        notificationEmailName: string;
        pageTitle: string;
        customDomain?: string | undefined;
        disabledFeatures?: import("@signageos/common-types/dist/Feature/FeatureFlag").FeatureFlag[] | undefined;
        disabledEmailTypes?: import("@signageos/common-types/dist/Email/EmailType").EmailType[] | undefined;
        emailTemplateType?: string | undefined;
        privacyPolicyUrl?: string | undefined;
        auth0Config?: {
            domain: string;
            clientId: string;
            organizationDomain?: string | undefined;
            organizationClientId?: string | undefined;
        } | undefined;
    };
    uiTheme: {
        uid: string;
        logo: string;
        topBarBackgroundColor1: string;
        topBarBackgroundColor2: string;
        tabsCardActiveColor: string;
        tabsCardActiveBackground: string;
        btnPrimaryColor: string;
        btnPrimaryBackground: string;
        menuItemColor: string;
        menuItemHoverBackground: string;
        menuItemActiveBackground: string;
        hideMenuButtonColor: string;
        textColor: string;
        cardTitleColor: string;
        favicon?: string | undefined;
        logoSmall?: string | undefined;
        layout?: import("@signageos/common-types/dist/Layout/LayoutType").LayoutType | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "WhiteLabelSettings.CreateWhiteLabelSettingsWithUITheme";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    whiteLabelSettings: {
        uid: string;
        emailFooter: string;
        notificationEmailAddress: string;
        notificationEmailName: string;
        pageTitle: string;
        customDomain?: string | undefined;
        disabledFeatures?: import("@signageos/common-types/dist/Feature/FeatureFlag").FeatureFlag[] | undefined;
        disabledEmailTypes?: import("@signageos/common-types/dist/Email/EmailType").EmailType[] | undefined;
        emailTemplateType?: string | undefined;
        privacyPolicyUrl?: string | undefined;
        auth0Config?: {
            domain: string;
            clientId: string;
            organizationDomain?: string | undefined;
            organizationClientId?: string | undefined;
        } | undefined;
    };
    uiTheme: {
        uid: string;
        logo: string;
        topBarBackgroundColor1: string;
        topBarBackgroundColor2: string;
        tabsCardActiveColor: string;
        tabsCardActiveBackground: string;
        btnPrimaryColor: string;
        btnPrimaryBackground: string;
        menuItemColor: string;
        menuItemHoverBackground: string;
        menuItemActiveBackground: string;
        hideMenuButtonColor: string;
        textColor: string;
        cardTitleColor: string;
        favicon?: string | undefined;
        logoSmall?: string | undefined;
        layout?: import("@signageos/common-types/dist/Layout/LayoutType").LayoutType | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const UpdateWhiteLabelSettings = "WhiteLabelSettings.UpdateWhiteLabelSettings";
export declare const UpdateWhiteLabelSettingsSchema: import("../Entity/entityCommands").UpdateEntityCommandSchema<"WhiteLabelSettings.UpdateWhiteLabelSettings", {
    uid: z.ZodString;
    customDomain: z.ZodOptional<z.ZodEffects<z.ZodString, string, string>>;
    emailFooter: z.ZodString;
    notificationEmailAddress: z.ZodString;
    notificationEmailName: z.ZodString;
    pageTitle: z.ZodString;
    disabledFeatures: z.ZodOptional<z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Feature/FeatureFlag").FeatureFlag>, "many">>;
    disabledEmailTypes: z.ZodOptional<z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Email/EmailType").EmailType>, "many">>;
    emailTemplateType: z.ZodOptional<z.ZodString>;
    privacyPolicyUrl: z.ZodOptional<z.ZodString>;
    auth0Config: z.ZodOptional<z.ZodObject<{
        domain: z.ZodString;
        clientId: z.ZodString;
        organizationDomain: z.ZodOptional<z.ZodString>;
        organizationClientId: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        domain: string;
        clientId: string;
        organizationDomain?: string | undefined;
        organizationClientId?: string | undefined;
    }, {
        domain: string;
        clientId: string;
        organizationDomain?: string | undefined;
        organizationClientId?: string | undefined;
    }>>;
}>;
export type UpdateWhiteLabelSettings = z.infer<typeof UpdateWhiteLabelSettingsSchema>;
export declare const UpdateWhiteLabelSettingsFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    customDomain?: string | null | undefined;
    emailFooter?: string | undefined;
    notificationEmailAddress?: string | undefined;
    notificationEmailName?: string | undefined;
    pageTitle?: string | undefined;
    disabledFeatures?: import("@signageos/common-types/dist/Feature/FeatureFlag").FeatureFlag[] | null | undefined;
    disabledEmailTypes?: import("@signageos/common-types/dist/Email/EmailType").EmailType[] | null | undefined;
    emailTemplateType?: string | null | undefined;
    privacyPolicyUrl?: string | null | undefined;
    auth0Config?: {
        domain: string;
        clientId: string;
        organizationDomain?: string | undefined;
        organizationClientId?: string | undefined;
    } | null | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "WhiteLabelSettings.UpdateWhiteLabelSettings";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    customDomain?: string | null | undefined;
    emailFooter?: string | undefined;
    notificationEmailAddress?: string | undefined;
    notificationEmailName?: string | undefined;
    pageTitle?: string | undefined;
    disabledFeatures?: import("@signageos/common-types/dist/Feature/FeatureFlag").FeatureFlag[] | null | undefined;
    disabledEmailTypes?: import("@signageos/common-types/dist/Email/EmailType").EmailType[] | null | undefined;
    emailTemplateType?: string | null | undefined;
    privacyPolicyUrl?: string | null | undefined;
    auth0Config?: {
        domain: string;
        clientId: string;
        organizationDomain?: string | undefined;
        organizationClientId?: string | undefined;
    } | null | undefined;
}, {}, Function>>) => z.TypeOf<import("../Entity/entityCommands").UpdateEntityCommandSchema<"WhiteLabelSettings.UpdateWhiteLabelSettings", {
    uid: z.ZodString;
    customDomain: z.ZodOptional<z.ZodEffects<z.ZodString, string, string>>;
    emailFooter: z.ZodString;
    notificationEmailAddress: z.ZodString;
    notificationEmailName: z.ZodString;
    pageTitle: z.ZodString;
    disabledFeatures: z.ZodOptional<z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Feature/FeatureFlag").FeatureFlag>, "many">>;
    disabledEmailTypes: z.ZodOptional<z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Email/EmailType").EmailType>, "many">>;
    emailTemplateType: z.ZodOptional<z.ZodString>;
    privacyPolicyUrl: z.ZodOptional<z.ZodString>;
    auth0Config: z.ZodOptional<z.ZodObject<{
        domain: z.ZodString;
        clientId: z.ZodString;
        organizationDomain: z.ZodOptional<z.ZodString>;
        organizationClientId: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        domain: string;
        clientId: string;
        organizationDomain?: string | undefined;
        organizationClientId?: string | undefined;
    }, {
        domain: string;
        clientId: string;
        organizationDomain?: string | undefined;
        organizationClientId?: string | undefined;
    }>>;
}>>;
export declare const AssignWhiteLabelSettingsToCompany = "WhiteLabelSettings.AssignToCompany";
export declare const AssignWhiteLabelSettingsToCompanySchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"WhiteLabelSettings.AssignToCompany">;
    companyUid: z.ZodString;
    whiteLabelSettingsUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "WhiteLabelSettings.AssignToCompany";
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "WhiteLabelSettings.AssignToCompany";
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type AssignWhiteLabelSettingsToCompany = z.infer<typeof AssignWhiteLabelSettingsToCompanySchema>;
export declare const AssignWhiteLabelSettingsToCompanyFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "WhiteLabelSettings.AssignToCompany";
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"WhiteLabelSettings.AssignToCompany">;
    companyUid: z.ZodString;
    whiteLabelSettingsUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "WhiteLabelSettings.AssignToCompany";
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "WhiteLabelSettings.AssignToCompany";
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const UnassignWhiteLabelSettingsFromCompany = "WhiteLabelSettings.UnassignFromCompany";
export declare const UnassignWhiteLabelSettingsFromCompanySchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"WhiteLabelSettings.UnassignFromCompany">;
    companyUid: z.ZodString;
    whiteLabelSettingsUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "WhiteLabelSettings.UnassignFromCompany";
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "WhiteLabelSettings.UnassignFromCompany";
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type UnassignWhiteLabelSettingsFromCompany = z.infer<typeof UnassignWhiteLabelSettingsFromCompanySchema>;
export declare const UnassignWhiteLabelSettingsFromCompanyFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "WhiteLabelSettings.UnassignFromCompany";
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"WhiteLabelSettings.UnassignFromCompany">;
    companyUid: z.ZodString;
    whiteLabelSettingsUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "WhiteLabelSettings.UnassignFromCompany";
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "WhiteLabelSettings.UnassignFromCompany";
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
