import { z } from 'zod';
export declare const UIThemeSchema: z.ZodObject<{
    uid: z.ZodString;
    logo: z.ZodString;
    topBarBackgroundColor1: z.ZodEffects<z.ZodString, string, string>;
    topBarBackgroundColor2: z.ZodEffects<z.ZodString, string, string>;
    tabsCardActiveColor: z.ZodEffects<z.ZodString, string, string>;
    tabsCardActiveBackground: z.ZodEffects<z.ZodString, string, string>;
    btnPrimaryColor: z.ZodEffects<z.ZodString, string, string>;
    btnPrimaryBackground: z.ZodEffects<z.ZodString, string, string>;
    menuItemColor: z.ZodEffects<z.ZodString, string, string>;
    menuItemHoverBackground: z.ZodEffects<z.ZodString, string, string>;
    menuItemActiveBackground: z.ZodEffects<z.ZodString, string, string>;
    hideMenuButtonColor: z.ZodEffects<z.ZodString, string, string>;
    textColor: z.ZodEffects<z.ZodString, string, string>;
    cardTitleColor: z.ZodEffects<z.ZodString, string, string>;
    favicon: z.ZodOptional<z.ZodString>;
    logoSmall: z.ZodOptional<z.ZodString>;
    layout: z.ZodOptional<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Layout/LayoutType").LayoutType>>;
}, "strict", z.ZodTypeAny, {
    uid: string;
    logo: string;
    topBarBackgroundColor1: string;
    topBarBackgroundColor2: string;
    tabsCardActiveColor: string;
    tabsCardActiveBackground: string;
    btnPrimaryColor: string;
    btnPrimaryBackground: string;
    menuItemColor: string;
    menuItemHoverBackground: string;
    menuItemActiveBackground: string;
    hideMenuButtonColor: string;
    textColor: string;
    cardTitleColor: string;
    favicon?: string | undefined;
    logoSmall?: string | undefined;
    layout?: import("@signageos/common-types/dist/Layout/LayoutType").LayoutType | undefined;
}, {
    uid: string;
    logo: string;
    topBarBackgroundColor1: string;
    topBarBackgroundColor2: string;
    tabsCardActiveColor: string;
    tabsCardActiveBackground: string;
    btnPrimaryColor: string;
    btnPrimaryBackground: string;
    menuItemColor: string;
    menuItemHoverBackground: string;
    menuItemActiveBackground: string;
    hideMenuButtonColor: string;
    textColor: string;
    cardTitleColor: string;
    favicon?: string | undefined;
    logoSmall?: string | undefined;
    layout?: import("@signageos/common-types/dist/Layout/LayoutType").LayoutType | undefined;
}>;
export declare const UIThemeUIDSchema: z.ZodString;
export declare const UpdateUITheme = "UITheme.UpdateUITheme";
export declare const UpdateUIThemeSchema: import("../Entity/entityCommands").UpdateEntityCommandSchema<"UITheme.UpdateUITheme", {
    uid: z.ZodString;
    logo: z.ZodString;
    topBarBackgroundColor1: z.ZodEffects<z.ZodString, string, string>;
    topBarBackgroundColor2: z.ZodEffects<z.ZodString, string, string>;
    tabsCardActiveColor: z.ZodEffects<z.ZodString, string, string>;
    tabsCardActiveBackground: z.ZodEffects<z.ZodString, string, string>;
    btnPrimaryColor: z.ZodEffects<z.ZodString, string, string>;
    btnPrimaryBackground: z.ZodEffects<z.ZodString, string, string>;
    menuItemColor: z.ZodEffects<z.ZodString, string, string>;
    menuItemHoverBackground: z.ZodEffects<z.ZodString, string, string>;
    menuItemActiveBackground: z.ZodEffects<z.ZodString, string, string>;
    hideMenuButtonColor: z.ZodEffects<z.ZodString, string, string>;
    textColor: z.ZodEffects<z.ZodString, string, string>;
    cardTitleColor: z.ZodEffects<z.ZodString, string, string>;
    favicon: z.ZodOptional<z.ZodString>;
    logoSmall: z.ZodOptional<z.ZodString>;
    layout: z.ZodOptional<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Layout/LayoutType").LayoutType>>;
}>;
export type UpdateUITheme = z.infer<typeof UpdateUIThemeSchema>;
export declare const UpdateUIThemeFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    logo?: string | undefined;
    topBarBackgroundColor1?: string | undefined;
    topBarBackgroundColor2?: string | undefined;
    tabsCardActiveColor?: string | undefined;
    tabsCardActiveBackground?: string | undefined;
    btnPrimaryColor?: string | undefined;
    btnPrimaryBackground?: string | undefined;
    menuItemColor?: string | undefined;
    menuItemHoverBackground?: string | undefined;
    menuItemActiveBackground?: string | undefined;
    hideMenuButtonColor?: string | undefined;
    textColor?: string | undefined;
    cardTitleColor?: string | undefined;
    favicon?: string | null | undefined;
    logoSmall?: string | null | undefined;
    layout?: import("@signageos/common-types/dist/Layout/LayoutType").LayoutType | null | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "UITheme.UpdateUITheme";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    logo?: string | undefined;
    topBarBackgroundColor1?: string | undefined;
    topBarBackgroundColor2?: string | undefined;
    tabsCardActiveColor?: string | undefined;
    tabsCardActiveBackground?: string | undefined;
    btnPrimaryColor?: string | undefined;
    btnPrimaryBackground?: string | undefined;
    menuItemColor?: string | undefined;
    menuItemHoverBackground?: string | undefined;
    menuItemActiveBackground?: string | undefined;
    hideMenuButtonColor?: string | undefined;
    textColor?: string | undefined;
    cardTitleColor?: string | undefined;
    favicon?: string | null | undefined;
    logoSmall?: string | null | undefined;
    layout?: import("@signageos/common-types/dist/Layout/LayoutType").LayoutType | null | undefined;
}, {}, Function>>) => z.TypeOf<import("../Entity/entityCommands").UpdateEntityCommandSchema<"UITheme.UpdateUITheme", {
    uid: z.ZodString;
    logo: z.ZodString;
    topBarBackgroundColor1: z.ZodEffects<z.ZodString, string, string>;
    topBarBackgroundColor2: z.ZodEffects<z.ZodString, string, string>;
    tabsCardActiveColor: z.ZodEffects<z.ZodString, string, string>;
    tabsCardActiveBackground: z.ZodEffects<z.ZodString, string, string>;
    btnPrimaryColor: z.ZodEffects<z.ZodString, string, string>;
    btnPrimaryBackground: z.ZodEffects<z.ZodString, string, string>;
    menuItemColor: z.ZodEffects<z.ZodString, string, string>;
    menuItemHoverBackground: z.ZodEffects<z.ZodString, string, string>;
    menuItemActiveBackground: z.ZodEffects<z.ZodString, string, string>;
    hideMenuButtonColor: z.ZodEffects<z.ZodString, string, string>;
    textColor: z.ZodEffects<z.ZodString, string, string>;
    cardTitleColor: z.ZodEffects<z.ZodString, string, string>;
    favicon: z.ZodOptional<z.ZodString>;
    logoSmall: z.ZodOptional<z.ZodString>;
    layout: z.ZodOptional<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Layout/LayoutType").LayoutType>>;
}>>;
