"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteTimingFactory = exports.DeleteTimingSchema = exports.DeleteTiming = exports.UpdateTimingFactory = exports.UpdateTimingSchema = exports.UpdateTiming = exports.CreateTimingFactory = exports.CreateTimingSchema = exports.CreateTiming = exports.identification = exports.IDENTIFICATION_LENGTH = void 0;
const ICommand_1 = require("../ICommand");
const zod_1 = require("zod");
const schemas_1 = require("../schemas");
const commandFactory_1 = require("../commandFactory");
const generators_1 = require("../generators");
const generator_1 = require("@signageos/lib/dist/Hash/generator");
const FinishEventType_1 = require("@signageos/common-types/dist/Timing/FinishEventType");
exports.IDENTIFICATION_LENGTH = 10;
const identification = () => (0, generator_1.generateUniqueHash)(exports.IDENTIFICATION_LENGTH);
exports.identification = identification;
const PositionSchema = zod_1.z.number().min(0).max(Number.MAX_SAFE_INTEGER);
exports.CreateTiming = 'Timing.CreateTiming';
exports.CreateTimingSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.CreateTiming),
    // TODO: temporary solution because of backwards compatibility with old box
    uid: schemas_1.UIDSchema.or(schemas_1.LegacyUIDSchema),
    appletUid: zod_1.z.string(),
    deviceIdentityHash: zod_1.z.string(),
    appletVersion: zod_1.z.string(),
    /**
     * Timing will be active from startsAt to endsAt.
     * If not provided, the default value will be 1970-01-01.
     * @deprecated shouldn't be used anymore; will be removed in the future
     */
    startsAt: zod_1.z.date().optional(),
    /**
     * Timing will be active from startsAt to endsAt.
     * If not provided, the default value will be 2030-12-31.
     * @deprecated shouldn't be used anymore; will be removed in the future
     */
    endsAt: zod_1.z.date().optional(),
    configuration: zod_1.z.record(zod_1.z.string(), zod_1.z.unknown()),
    /** @deprecated can be omitted; default value will be generated for backwards compatibility; will be removed in the future */
    finishEvent: zod_1.z
        .object({
        type: FinishEventType_1.FinishEventTypeSchema,
        data: zod_1.z.any().optional(),
    })
        .optional(),
    /** @deprecated can be omitted; default value will be generated for backwards compatibility; will be removed in the future */
    position: PositionSchema.optional(),
    /**
     * If true, other timings on the same device will be disabled.
     * If not provided, default value will be generated from startsAt/endsAt based on the current time.
     * If neither startsAt nor endsAt is provided, the default value will be true.
     */
    active: zod_1.z.boolean().optional(),
}).strict();
exports.CreateTimingFactory = (0, commandFactory_1.createCommandFactory)(exports.CreateTimingSchema, { uid: generators_1.uid });
exports.UpdateTiming = 'Timing.UpdateTiming';
/**
 * configuration - rewrites whole configuration of timings
 * configurationSet - adds or modifies existing properties in configuration
 * configurationRemoveKeys - removes properties from configuration
 */
exports.UpdateTimingSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.UpdateTiming),
    uid: schemas_1.UIDSchema.or(schemas_1.LegacyUIDSchema),
    appletUid: zod_1.z.string(),
    deviceIdentityHash: zod_1.z.string(),
    appletVersion: zod_1.z.string().optional(),
    /** @deprecated can be omitted; default value will be generated for backwards compatibility; will be removed in the future */
    startsAt: zod_1.z.date().optional(),
    /** @deprecated can be omitted; default value will be generated for backwards compatibility; will be removed in the future */
    endsAt: zod_1.z.date().optional(),
    configuration: zod_1.z.record(zod_1.z.string(), zod_1.z.unknown()).optional(),
    configurationSet: zod_1.z.record(zod_1.z.string(), zod_1.z.unknown()).optional(),
    configurationRemoveKeys: zod_1.z.array(zod_1.z.string()).optional(),
    /** @deprecated can be omitted; default value will be generated for backwards compatibility; will be removed in the future */
    finishEvent: zod_1.z
        .object({
        type: FinishEventType_1.FinishEventTypeSchema.optional(),
        data: zod_1.z.any().optional(),
    })
        .optional(),
    /** @deprecated can be omitted; default value will be generated for backwards compatibility; will be removed in the future */
    position: PositionSchema.optional(),
    /** If true, other timings on the same device will be disabled */
    active: zod_1.z.boolean().optional(),
}).strict();
exports.UpdateTimingFactory = (0, commandFactory_1.createCommandFactory)(exports.UpdateTimingSchema);
exports.DeleteTiming = 'Timing.DeleteTiming';
exports.DeleteTimingSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.DeleteTiming),
    uid: schemas_1.UIDSchema.or(schemas_1.LegacyUIDSchema),
    appletUid: zod_1.z.string(),
    appletVersion: zod_1.z.string(),
});
exports.DeleteTimingFactory = (0, commandFactory_1.createCommandFactory)(exports.DeleteTimingSchema);
//# sourceMappingURL=timingCommands.js.map