import { z } from 'zod';
export declare const IDENTIFICATION_LENGTH = 10;
export declare const identification: () => string;
export declare const CreateTiming = "Timing.CreateTiming";
export declare const CreateTimingSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Timing.CreateTiming">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    appletUid: z.ZodString;
    deviceIdentityHash: z.ZodString;
    appletVersion: z.ZodString;
    startsAt: z.ZodOptional<z.ZodDate>;
    endsAt: z.ZodOptional<z.ZodDate>;
    configuration: z.ZodRecord<z.ZodString, z.ZodUnknown>;
    finishEvent: z.ZodOptional<z.ZodObject<{
        type: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType>;
        data: z.ZodOptional<z.ZodAny>;
    }, "strip", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
        data?: any;
    }, {
        type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
        data?: any;
    }>>;
    position: z.ZodOptional<z.ZodNumber>;
    active: z.ZodOptional<z.ZodBoolean>;
}, "strict", z.ZodTypeAny, {
    type: "Timing.CreateTiming";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceIdentityHash: string;
    appletUid: string;
    appletVersion: string;
    configuration: Record<string, unknown>;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    startsAt?: Date | undefined;
    endsAt?: Date | undefined;
    finishEvent?: {
        type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
        data?: any;
    } | undefined;
    position?: number | undefined;
    active?: boolean | undefined;
}, {
    type: "Timing.CreateTiming";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceIdentityHash: string;
    appletUid: string;
    appletVersion: string;
    configuration: Record<string, unknown>;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    startsAt?: Date | undefined;
    endsAt?: Date | undefined;
    finishEvent?: {
        type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
        data?: any;
    } | undefined;
    position?: number | undefined;
    active?: boolean | undefined;
}>;
export type CreateTiming = z.infer<typeof CreateTimingSchema>;
export declare const CreateTimingFactory: (data: {
    active?: boolean | undefined;
    position?: number | undefined;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    startsAt?: Date | undefined;
    endsAt?: Date | undefined;
    finishEvent?: {
        type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
        data?: any;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    appletUid: string;
    appletVersion: string;
    configuration: Record<string, unknown>;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Timing.CreateTiming";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceIdentityHash: string;
    appletUid: string;
    appletVersion: string;
    configuration: Record<string, unknown>;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    startsAt?: Date | undefined;
    endsAt?: Date | undefined;
    finishEvent?: {
        type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
        data?: any;
    } | undefined;
    position?: number | undefined;
    active?: boolean | undefined;
}, {
    uid: () => string;
}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Timing.CreateTiming">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    appletUid: z.ZodString;
    deviceIdentityHash: z.ZodString;
    appletVersion: z.ZodString;
    startsAt: z.ZodOptional<z.ZodDate>;
    endsAt: z.ZodOptional<z.ZodDate>;
    configuration: z.ZodRecord<z.ZodString, z.ZodUnknown>;
    finishEvent: z.ZodOptional<z.ZodObject<{
        type: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType>;
        data: z.ZodOptional<z.ZodAny>;
    }, "strip", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
        data?: any;
    }, {
        type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
        data?: any;
    }>>;
    position: z.ZodOptional<z.ZodNumber>;
    active: z.ZodOptional<z.ZodBoolean>;
}, "strict", z.ZodTypeAny, {
    type: "Timing.CreateTiming";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceIdentityHash: string;
    appletUid: string;
    appletVersion: string;
    configuration: Record<string, unknown>;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    startsAt?: Date | undefined;
    endsAt?: Date | undefined;
    finishEvent?: {
        type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
        data?: any;
    } | undefined;
    position?: number | undefined;
    active?: boolean | undefined;
}, {
    type: "Timing.CreateTiming";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceIdentityHash: string;
    appletUid: string;
    appletVersion: string;
    configuration: Record<string, unknown>;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    startsAt?: Date | undefined;
    endsAt?: Date | undefined;
    finishEvent?: {
        type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
        data?: any;
    } | undefined;
    position?: number | undefined;
    active?: boolean | undefined;
}>>;
export declare const UpdateTiming = "Timing.UpdateTiming";
/**
 * configuration - rewrites whole configuration of timings
 * configurationSet - adds or modifies existing properties in configuration
 * configurationRemoveKeys - removes properties from configuration
 */
export declare const UpdateTimingSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Timing.UpdateTiming">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    appletUid: z.ZodString;
    deviceIdentityHash: z.ZodString;
    appletVersion: z.ZodOptional<z.ZodString>;
    startsAt: z.ZodOptional<z.ZodDate>;
    endsAt: z.ZodOptional<z.ZodDate>;
    configuration: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    configurationSet: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    configurationRemoveKeys: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    finishEvent: z.ZodOptional<z.ZodObject<{
        type: z.ZodOptional<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType>>;
        data: z.ZodOptional<z.ZodAny>;
    }, "strip", z.ZodTypeAny, {
        type?: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
        data?: any;
    }, {
        type?: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
        data?: any;
    }>>;
    position: z.ZodOptional<z.ZodNumber>;
    active: z.ZodOptional<z.ZodBoolean>;
}, "strict", z.ZodTypeAny, {
    type: "Timing.UpdateTiming";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceIdentityHash: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    appletVersion?: string | undefined;
    startsAt?: Date | undefined;
    endsAt?: Date | undefined;
    configuration?: Record<string, unknown> | undefined;
    configurationSet?: Record<string, unknown> | undefined;
    configurationRemoveKeys?: string[] | undefined;
    finishEvent?: {
        type?: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
        data?: any;
    } | undefined;
    position?: number | undefined;
    active?: boolean | undefined;
}, {
    type: "Timing.UpdateTiming";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceIdentityHash: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    appletVersion?: string | undefined;
    startsAt?: Date | undefined;
    endsAt?: Date | undefined;
    configuration?: Record<string, unknown> | undefined;
    configurationSet?: Record<string, unknown> | undefined;
    configurationRemoveKeys?: string[] | undefined;
    finishEvent?: {
        type?: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
        data?: any;
    } | undefined;
    position?: number | undefined;
    active?: boolean | undefined;
}>;
export type UpdateTiming = z.infer<typeof UpdateTimingSchema>;
export declare const UpdateTimingFactory: (data: {
    active?: boolean | undefined;
    position?: number | undefined;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    appletVersion?: string | undefined;
    startsAt?: Date | undefined;
    endsAt?: Date | undefined;
    configuration?: Record<string, unknown> | undefined;
    finishEvent?: {
        type?: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
        data?: any;
    } | undefined;
    configurationSet?: Record<string, unknown> | undefined;
    configurationRemoveKeys?: string[] | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceIdentityHash: string;
    appletUid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Timing.UpdateTiming";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceIdentityHash: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    appletVersion?: string | undefined;
    startsAt?: Date | undefined;
    endsAt?: Date | undefined;
    configuration?: Record<string, unknown> | undefined;
    configurationSet?: Record<string, unknown> | undefined;
    configurationRemoveKeys?: string[] | undefined;
    finishEvent?: {
        type?: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
        data?: any;
    } | undefined;
    position?: number | undefined;
    active?: boolean | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Timing.UpdateTiming">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    appletUid: z.ZodString;
    deviceIdentityHash: z.ZodString;
    appletVersion: z.ZodOptional<z.ZodString>;
    startsAt: z.ZodOptional<z.ZodDate>;
    endsAt: z.ZodOptional<z.ZodDate>;
    configuration: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    configurationSet: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    configurationRemoveKeys: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    finishEvent: z.ZodOptional<z.ZodObject<{
        type: z.ZodOptional<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType>>;
        data: z.ZodOptional<z.ZodAny>;
    }, "strip", z.ZodTypeAny, {
        type?: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
        data?: any;
    }, {
        type?: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
        data?: any;
    }>>;
    position: z.ZodOptional<z.ZodNumber>;
    active: z.ZodOptional<z.ZodBoolean>;
}, "strict", z.ZodTypeAny, {
    type: "Timing.UpdateTiming";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceIdentityHash: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    appletVersion?: string | undefined;
    startsAt?: Date | undefined;
    endsAt?: Date | undefined;
    configuration?: Record<string, unknown> | undefined;
    configurationSet?: Record<string, unknown> | undefined;
    configurationRemoveKeys?: string[] | undefined;
    finishEvent?: {
        type?: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
        data?: any;
    } | undefined;
    position?: number | undefined;
    active?: boolean | undefined;
}, {
    type: "Timing.UpdateTiming";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceIdentityHash: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    appletVersion?: string | undefined;
    startsAt?: Date | undefined;
    endsAt?: Date | undefined;
    configuration?: Record<string, unknown> | undefined;
    configurationSet?: Record<string, unknown> | undefined;
    configurationRemoveKeys?: string[] | undefined;
    finishEvent?: {
        type?: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
        data?: any;
    } | undefined;
    position?: number | undefined;
    active?: boolean | undefined;
}>>;
export declare const DeleteTiming = "Timing.DeleteTiming";
export declare const DeleteTimingSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Timing.DeleteTiming">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    appletUid: z.ZodString;
    appletVersion: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Timing.DeleteTiming";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    appletUid: string;
    appletVersion: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Timing.DeleteTiming";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    appletUid: string;
    appletVersion: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type DeleteTiming = z.infer<typeof DeleteTimingSchema>;
export declare const DeleteTimingFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    appletUid: string;
    appletVersion: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Timing.DeleteTiming";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    appletUid: string;
    appletVersion: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Timing.DeleteTiming">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    appletUid: z.ZodString;
    appletVersion: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Timing.DeleteTiming";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    appletUid: string;
    appletVersion: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Timing.DeleteTiming";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    appletUid: string;
    appletVersion: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
