"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetThirdPartyCredentialsFactory = exports.SetThirdPartyCredentialsSchema = exports.SetThirdPartyCredentials = void 0;
const zod_1 = require("zod");
const ICommand_1 = require("../ICommand");
const organizationCommands_1 = require("../Organization/organizationCommands");
const commandFactory_1 = require("../commandFactory");
const schemas_1 = require("../schemas");
exports.SetThirdPartyCredentials = 'ThirdPartyCredentials.Set';
const ThirdPartyCredentialsBase = zod_1.z.object({
    type: zod_1.z.literal(exports.SetThirdPartyCredentials),
    uid: schemas_1.UIDSchema,
    organizationUid: organizationCommands_1.OrganizationUIDSchema,
});
const GoogleCredentials = ThirdPartyCredentialsBase.extend({
    thirdPartyType: zod_1.z.literal('google'),
    clientEmail: zod_1.z.string().email(),
    customerId: zod_1.z.string(),
    privateKey: zod_1.z.string(),
});
/**
 * @description Set third party credentials for organization
 * @param organizationUid - is unique per type and if there are already credentials
 * for that organization with that type they will be overwritten
 */
exports.SetThirdPartyCredentialsSchema = ICommand_1.OriginatorAwareCommandSchema.merge(GoogleCredentials).strict();
exports.SetThirdPartyCredentialsFactory = (0, commandFactory_1.createCommandFactory)(exports.SetThirdPartyCredentialsSchema);
//# sourceMappingURL=thirdPartyCredentialsCommands.js.map