import { z } from 'zod';
export declare const CreateTermsAndConditionsVersion = "TermsAndConditions.CreateTermsAndConditionsVersion";
/**
 * termsAndConditionsUid is unique identifier of the entity together with version
 */
export declare const CreateTermsAndConditionsVersionSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"TermsAndConditions.CreateTermsAndConditionsVersion">;
    termsAndConditionsUid: z.ZodString;
    url: z.ZodString;
    version: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "TermsAndConditions.CreateTermsAndConditionsVersion";
    url: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    termsAndConditionsUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "TermsAndConditions.CreateTermsAndConditionsVersion";
    url: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    termsAndConditionsUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type CreateTermsAndConditionsVersion = z.infer<typeof CreateTermsAndConditionsVersionSchema>;
export declare const CreateTermsAndConditionsVersionFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    url: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    termsAndConditionsUid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "TermsAndConditions.CreateTermsAndConditionsVersion";
    url: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    termsAndConditionsUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"TermsAndConditions.CreateTermsAndConditionsVersion">;
    termsAndConditionsUid: z.ZodString;
    url: z.ZodString;
    version: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "TermsAndConditions.CreateTermsAndConditionsVersion";
    url: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    termsAndConditionsUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "TermsAndConditions.CreateTermsAndConditionsVersion";
    url: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    termsAndConditionsUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
