import { z } from 'zod';
export declare const MarkTermsAgreed = "Terms.MarkAgreed";
export declare const MarkTermsAgreedSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Terms.MarkAgreed">;
    accountId: z.ZodNumber;
    termsAndConditionsUid: z.ZodOptional<z.ZodString>;
    dateAgreedOn: z.ZodDate;
    termsVersion: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Terms.MarkAgreed";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    dateAgreedOn: Date;
    termsVersion: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    termsAndConditionsUid?: string | undefined;
}, {
    type: "Terms.MarkAgreed";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    dateAgreedOn: Date;
    termsVersion: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    termsAndConditionsUid?: string | undefined;
}>;
export type MarkTermsAgreed = z.infer<typeof MarkTermsAgreedSchema>;
export declare const MarkTermsAgreedFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    termsAndConditionsUid?: string | undefined;
} & {
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    dateAgreedOn: Date;
    termsVersion: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Terms.MarkAgreed";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    dateAgreedOn: Date;
    termsVersion: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    termsAndConditionsUid?: string | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Terms.MarkAgreed">;
    accountId: z.ZodNumber;
    termsAndConditionsUid: z.ZodOptional<z.ZodString>;
    dateAgreedOn: z.ZodDate;
    termsVersion: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Terms.MarkAgreed";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    dateAgreedOn: Date;
    termsVersion: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    termsAndConditionsUid?: string | undefined;
}, {
    type: "Terms.MarkAgreed";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    dateAgreedOn: Date;
    termsVersion: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    termsAndConditionsUid?: string | undefined;
}>>;
