"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnarchiveOrganizationFactory = exports.UnarchiveOrganizationSchema = exports.UnarchiveOrganization = exports.ArchiveOrganizationFactory = exports.ArchiveOrganizationSchema = exports.ArchiveOrganization = exports.RevokeOrganizationUserVPNConfigFactory = exports.RevokeOrganizationUserVPNConfigSchema = exports.RevokeOrganizationUserVPNConfig = exports.CreateOrganizationUserVPNConfigFactory = exports.CreateOrganizationUserVPNConfigSchema = exports.CreateOrganizationUserVPNConfig = exports.SetOrganizationVpnFactory = exports.SetOrganizationVpnSchema = exports.SetOrganizationVpn = exports.SetOrganizationReporterFactory = exports.SetOrganizationReportersSchema = exports.SetOrganizationReporters = exports.ClearEndOfTrialPeriod = exports.SetEndOfTrialPeriod = exports.SetMaxDevicesCount = exports.SetOrganizationParentalCompany = exports.ToggleOrganizationProductionState = exports.DeleteOrganization = exports.ChangeOrganizationSubscription = exports.UpdateOrganizationFactory = exports.UpdateOrganizationSchema = exports.UpdateOrganization = exports.CreateOrganizationFactory = exports.CreateOrganizationSchema = exports.CreateOrganization = exports.OrganizationUIDSchema = void 0;
const zod_1 = require("zod");
const subscription_1 = require("@signageos/common-types/dist/Subscription/subscription");
const string_1 = require("@signageos/lib/dist/String/string");
const commandFactory_1 = require("../commandFactory");
const generators_1 = require("../generators");
const ICommand_1 = require("../ICommand");
const schemas_1 = require("../schemas");
const accountCommands_1 = require("../Account/accountCommands");
const location_1 = require("@signageos/common-types/dist/Location/location");
exports.OrganizationUIDSchema = schemas_1.UIDSchema.or(schemas_1.LegacyUIDSchema);
/**
 * Create new organization
 */
exports.CreateOrganization = 'Organization.CreateOrganization';
exports.CreateOrganizationSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.CreateOrganization),
    uid: schemas_1.UIDSchema, // Prevent creating organization with legacy uid
    companyUid: exports.OrganizationUIDSchema,
    accountId: accountCommands_1.AccountIdSchema,
    name: zod_1.z.string().min(2).max(255).regex(string_1.SUB_DOMAIN_SEGMENT_REG_EXP, {
        message: 'Name can contain only letters, numbers divided by dashes. It must start and end with a letter or a number.',
    }),
    title: zod_1.z.string().min(1).max(255),
    subscriptionType: zod_1.z.nativeEnum(subscription_1.SubscriptionType),
    /**
     * Custom icon for organization, it is optional and can be added later by user
     */
    iconUrl: zod_1.z.string().optional(),
}).strict();
exports.CreateOrganizationFactory = (0, commandFactory_1.createCommandFactory)(exports.CreateOrganizationSchema, { uid: generators_1.uid });
/**
 * Update existing organization
 */
exports.UpdateOrganization = 'Organization.UpdateOrganization';
exports.UpdateOrganizationSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.UpdateOrganization),
    uid: exports.OrganizationUIDSchema,
    title: zod_1.z.string().min(1).max(255).optional(),
    /**
     * Custom icon for organization
     */
    iconUrl: zod_1.z.string().optional().or(zod_1.z.null()),
    /**
     * Default map marker for locations under organization
     */
    locationDefaultMarker: zod_1.z.nativeEnum(location_1.LocationMarker).or(zod_1.z.null()).optional(),
});
exports.UpdateOrganizationFactory = (0, commandFactory_1.createCommandFactory)(exports.UpdateOrganizationSchema, {});
exports.ChangeOrganizationSubscription = 'Organization.ChangeOrganizationSubscriptionType';
exports.DeleteOrganization = 'Organization.DeleteOrganization';
exports.ToggleOrganizationProductionState = 'Organization.ToggleOrganizationProductionState';
exports.SetOrganizationParentalCompany = 'Organization.SetOrganizationParentalCompanyType';
exports.SetMaxDevicesCount = 'Organization.SetMaxDevicesCount';
exports.SetEndOfTrialPeriod = 'Organization.SetEndOfTrialPeriod';
exports.ClearEndOfTrialPeriod = 'Organization.ClearEndOfTrialPeriod';
exports.SetOrganizationReporters = 'Organization.SetOrganizationReporters';
exports.SetOrganizationReportersSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.SetOrganizationReporters),
    uid: exports.OrganizationUIDSchema,
    reporters: zod_1.z.object({
        adobe: zod_1.z
            .object({
            registrationKey: zod_1.z.string().min(1).max(255),
        })
            .optional(),
    }),
});
exports.SetOrganizationReporterFactory = (0, commandFactory_1.createCommandFactory)(exports.SetOrganizationReportersSchema, {});
exports.SetOrganizationVpn = 'Organization.SetOrganizationVpn';
exports.SetOrganizationVpnSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.SetOrganizationVpn),
    uid: exports.OrganizationUIDSchema,
    serverNameTag: zod_1.z.string().optional(),
});
exports.SetOrganizationVpnFactory = (0, commandFactory_1.createCommandFactory)(exports.SetOrganizationVpnSchema, {});
exports.CreateOrganizationUserVPNConfig = 'Organization.CreateOrganizationUserVPNConfig';
exports.CreateOrganizationUserVPNConfigSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.CreateOrganizationUserVPNConfig),
    uid: schemas_1.UIDSchema,
    orgUid: exports.OrganizationUIDSchema,
});
exports.CreateOrganizationUserVPNConfigFactory = (0, commandFactory_1.createCommandFactory)(exports.CreateOrganizationUserVPNConfigSchema, { uid: generators_1.uid });
exports.RevokeOrganizationUserVPNConfig = 'Organization.RevokeOrganizationUserVPNConfig';
exports.RevokeOrganizationUserVPNConfigSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.RevokeOrganizationUserVPNConfig),
    uid: schemas_1.UIDSchema,
    orgUid: exports.OrganizationUIDSchema,
});
exports.RevokeOrganizationUserVPNConfigFactory = (0, commandFactory_1.createCommandFactory)(exports.RevokeOrganizationUserVPNConfigSchema, {});
exports.ArchiveOrganization = 'Organization.ArchiveOrganization';
exports.ArchiveOrganizationSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.ArchiveOrganization),
    uid: exports.OrganizationUIDSchema,
});
exports.ArchiveOrganizationFactory = (0, commandFactory_1.createCommandFactory)(exports.ArchiveOrganizationSchema, {});
exports.UnarchiveOrganization = 'Organization.UnarchiveOrganization';
exports.UnarchiveOrganizationSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.UnarchiveOrganization),
    uid: exports.OrganizationUIDSchema,
});
exports.UnarchiveOrganizationFactory = (0, commandFactory_1.createCommandFactory)(exports.UnarchiveOrganizationSchema, {});
//# sourceMappingURL=organizationCommands.js.map