import { z } from 'zod';
import { SubscriptionType } from '@signageos/common-types/dist/Subscription/subscription';
import { BillingPlan } from '@signageos/common-types/dist/Billing/Billing';
import { IOriginatorAwareCommand } from '../ICommand';
export declare const CompanyUIDSchema: z.ZodUnion<[z.ZodString, z.ZodString]>;
export declare const CreateCompany = "Organization.CreateCompany";
export declare const CreateCompanySchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.CreateCompany">;
    companyUid: z.ZodString;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    name: z.ZodString;
    title: z.ZodString;
    billingPlan: z.ZodNativeEnum<typeof BillingPlan>;
    iconUrl: z.ZodOptional<z.ZodString>;
    licenses: z.ZodDefault<z.ZodObject<{
        dev_space: z.ZodObject<{
            users: z.ZodNumber;
            appBuildsPerMonth: z.ZodNumber;
        }, "strict", z.ZodTypeAny, {
            users: number;
            appBuildsPerMonth: number;
        }, {
            users: number;
            appBuildsPerMonth: number;
        }>;
    }, "strict", z.ZodTypeAny, {
        dev_space: {
            users: number;
            appBuildsPerMonth: number;
        };
    }, {
        dev_space: {
            users: number;
            appBuildsPerMonth: number;
        };
    }>>;
    organizationUid: z.ZodOptional<z.ZodString>;
    organizationTitlePostfix: z.ZodDefault<z.ZodString>;
    trialPeriodDuration: z.ZodDefault<z.ZodNumber>;
    commandTempVersion: z.ZodDefault<z.ZodNumber>;
}, "strict", z.ZodTypeAny, {
    name: string;
    type: "Organization.CreateCompany";
    title: string;
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    billingPlan: BillingPlan;
    licenses: {
        dev_space: {
            users: number;
            appBuildsPerMonth: number;
        };
    };
    organizationTitlePostfix: string;
    trialPeriodDuration: number;
    commandTempVersion: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    iconUrl?: string | undefined;
    organizationUid?: string | undefined;
}, {
    name: string;
    type: "Organization.CreateCompany";
    title: string;
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    billingPlan: BillingPlan;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    iconUrl?: string | undefined;
    licenses?: {
        dev_space: {
            users: number;
            appBuildsPerMonth: number;
        };
    } | undefined;
    organizationUid?: string | undefined;
    organizationTitlePostfix?: string | undefined;
    trialPeriodDuration?: number | undefined;
    commandTempVersion?: number | undefined;
}>;
export type CreateCompany = z.infer<typeof CreateCompanySchema>;
export declare const CreateCompanyFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    iconUrl?: string | undefined;
    licenses?: {
        dev_space: {
            users: number;
            appBuildsPerMonth: number;
        };
    } | undefined;
    organizationTitlePostfix?: string | undefined;
    trialPeriodDuration?: number | undefined;
    commandTempVersion?: number | undefined;
} & {
    name: string;
    title: string;
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    billingPlan: BillingPlan;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    name: string;
    type: "Organization.CreateCompany";
    title: string;
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    billingPlan: BillingPlan;
    licenses: {
        dev_space: {
            users: number;
            appBuildsPerMonth: number;
        };
    };
    organizationTitlePostfix: string;
    trialPeriodDuration: number;
    commandTempVersion: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    iconUrl?: string | undefined;
    organizationUid?: string | undefined;
}, {
    organizationUid: () => string;
}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.CreateCompany">;
    companyUid: z.ZodString;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    name: z.ZodString;
    title: z.ZodString;
    billingPlan: z.ZodNativeEnum<typeof BillingPlan>;
    iconUrl: z.ZodOptional<z.ZodString>;
    licenses: z.ZodDefault<z.ZodObject<{
        dev_space: z.ZodObject<{
            users: z.ZodNumber;
            appBuildsPerMonth: z.ZodNumber;
        }, "strict", z.ZodTypeAny, {
            users: number;
            appBuildsPerMonth: number;
        }, {
            users: number;
            appBuildsPerMonth: number;
        }>;
    }, "strict", z.ZodTypeAny, {
        dev_space: {
            users: number;
            appBuildsPerMonth: number;
        };
    }, {
        dev_space: {
            users: number;
            appBuildsPerMonth: number;
        };
    }>>;
    organizationUid: z.ZodOptional<z.ZodString>;
    organizationTitlePostfix: z.ZodDefault<z.ZodString>;
    trialPeriodDuration: z.ZodDefault<z.ZodNumber>;
    commandTempVersion: z.ZodDefault<z.ZodNumber>;
}, "strict", z.ZodTypeAny, {
    name: string;
    type: "Organization.CreateCompany";
    title: string;
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    billingPlan: BillingPlan;
    licenses: {
        dev_space: {
            users: number;
            appBuildsPerMonth: number;
        };
    };
    organizationTitlePostfix: string;
    trialPeriodDuration: number;
    commandTempVersion: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    iconUrl?: string | undefined;
    organizationUid?: string | undefined;
}, {
    name: string;
    type: "Organization.CreateCompany";
    title: string;
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    billingPlan: BillingPlan;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    iconUrl?: string | undefined;
    licenses?: {
        dev_space: {
            users: number;
            appBuildsPerMonth: number;
        };
    } | undefined;
    organizationUid?: string | undefined;
    organizationTitlePostfix?: string | undefined;
    trialPeriodDuration?: number | undefined;
    commandTempVersion?: number | undefined;
}>>;
export declare const UpdateCompany = "Organization.UpdateCompany";
/**
 * @defaultAccountRole null mean unset
 */
export declare const UpdateCompanySchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.UpdateCompany">;
    companyUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    title: z.ZodOptional<z.ZodString>;
    emailDomains: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    defaultAccountRole: z.ZodOptional<z.ZodNullable<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Account/Account").Role>>>;
    iconUrl: z.ZodOptional<z.ZodString>;
    licenses: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        dev_space: z.ZodObject<{
            users: z.ZodNumber;
            appBuildsPerMonth: z.ZodNumber;
        }, "strict", z.ZodTypeAny, {
            users: number;
            appBuildsPerMonth: number;
        }, {
            users: number;
            appBuildsPerMonth: number;
        }>;
    }, "strict", z.ZodTypeAny, {
        dev_space: {
            users: number;
            appBuildsPerMonth: number;
        };
    }, {
        dev_space: {
            users: number;
            appBuildsPerMonth: number;
        };
    }>>>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.UpdateCompany";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    title?: string | undefined;
    emailDomains?: string[] | undefined;
    defaultAccountRole?: import("@signageos/common-types/dist/Account/Account").Role | null | undefined;
    iconUrl?: string | undefined;
    licenses?: {
        dev_space: {
            users: number;
            appBuildsPerMonth: number;
        };
    } | null | undefined;
}, {
    type: "Organization.UpdateCompany";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    title?: string | undefined;
    emailDomains?: string[] | undefined;
    defaultAccountRole?: import("@signageos/common-types/dist/Account/Account").Role | null | undefined;
    iconUrl?: string | undefined;
    licenses?: {
        dev_space: {
            users: number;
            appBuildsPerMonth: number;
        };
    } | null | undefined;
}>;
export type UpdateCompany = z.infer<typeof UpdateCompanySchema>;
export declare const UpdateCompanyFactory: (data: {
    title?: string | undefined;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    iconUrl?: string | undefined;
    licenses?: {
        dev_space: {
            users: number;
            appBuildsPerMonth: number;
        };
    } | null | undefined;
    emailDomains?: string[] | undefined;
    defaultAccountRole?: import("@signageos/common-types/dist/Account/Account").Role | null | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Organization.UpdateCompany";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    title?: string | undefined;
    emailDomains?: string[] | undefined;
    defaultAccountRole?: import("@signageos/common-types/dist/Account/Account").Role | null | undefined;
    iconUrl?: string | undefined;
    licenses?: {
        dev_space: {
            users: number;
            appBuildsPerMonth: number;
        };
    } | null | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.UpdateCompany">;
    companyUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    title: z.ZodOptional<z.ZodString>;
    emailDomains: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    defaultAccountRole: z.ZodOptional<z.ZodNullable<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Account/Account").Role>>>;
    iconUrl: z.ZodOptional<z.ZodString>;
    licenses: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        dev_space: z.ZodObject<{
            users: z.ZodNumber;
            appBuildsPerMonth: z.ZodNumber;
        }, "strict", z.ZodTypeAny, {
            users: number;
            appBuildsPerMonth: number;
        }, {
            users: number;
            appBuildsPerMonth: number;
        }>;
    }, "strict", z.ZodTypeAny, {
        dev_space: {
            users: number;
            appBuildsPerMonth: number;
        };
    }, {
        dev_space: {
            users: number;
            appBuildsPerMonth: number;
        };
    }>>>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.UpdateCompany";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    title?: string | undefined;
    emailDomains?: string[] | undefined;
    defaultAccountRole?: import("@signageos/common-types/dist/Account/Account").Role | null | undefined;
    iconUrl?: string | undefined;
    licenses?: {
        dev_space: {
            users: number;
            appBuildsPerMonth: number;
        };
    } | null | undefined;
}, {
    type: "Organization.UpdateCompany";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    title?: string | undefined;
    emailDomains?: string[] | undefined;
    defaultAccountRole?: import("@signageos/common-types/dist/Account/Account").Role | null | undefined;
    iconUrl?: string | undefined;
    licenses?: {
        dev_space: {
            users: number;
            appBuildsPerMonth: number;
        };
    } | null | undefined;
}>>;
export type UpdateCompanyBillingInfoType = 'Organization.UpdateCompanyBillingInfo';
export declare const UpdateCompanyBillingInfo: UpdateCompanyBillingInfoType;
export interface UpdateCompanyBillingInfo extends IOriginatorAwareCommand<UpdateCompanyBillingInfoType> {
    companyUid: string;
    companyName: string;
    taxId?: string;
    street: string;
    street2?: string;
    postcode: string;
    city: string;
    state: string;
    country: string;
    email?: string;
    phone?: string;
    contactPersonName?: string;
    orderID?: string;
}
export type UpdateCompanyBillingPlanType = 'Organization.UpdateCompanyBillingPlan';
export declare const UpdateCompanyBillingPlan: UpdateCompanyBillingPlanType;
export interface UpdateCompanyBillingPlan extends IOriginatorAwareCommand<UpdateCompanyBillingPlanType> {
    companyUid: string;
    billingPlan: string;
}
export type DeleteCompanyType = 'Organization.DeleteCompany';
export declare const DeleteCompany: DeleteCompanyType;
export interface DeleteCompany extends IOriginatorAwareCommand<DeleteCompanyType> {
    companyUid: string;
}
export type SetCompanyDefaultSubscriptionType = 'Organization.SetCompanyDefaultSubscription';
export declare const SetCompanyDefaultSubscription: SetCompanyDefaultSubscriptionType;
export interface SetCompanyDefaultSubscription extends IOriginatorAwareCommand<SetCompanyDefaultSubscriptionType> {
    companyUid: string;
    defaultSubscriptionType: SubscriptionType;
}
export declare const SetDeviceNameTemplate = "Organization.SetDeviceNameTemplate";
export interface SetDeviceNameTemplate extends IOriginatorAwareCommand<typeof SetDeviceNameTemplate> {
    uid: string;
    template: string;
}
export type ArchiveCompanyType = 'Organization.ArchiveCompany';
export declare const ArchiveCompany: ArchiveCompanyType;
export declare const ArchiveCompanySchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.ArchiveCompany">;
    companyUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.ArchiveCompany";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Organization.ArchiveCompany";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type ArchiveCompany = z.infer<typeof ArchiveCompanySchema>;
export declare const ArchiveCompanyFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Organization.ArchiveCompany";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.ArchiveCompany">;
    companyUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.ArchiveCompany";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Organization.ArchiveCompany";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export type UnarchiveCompanyType = 'Organization.UnarchiveCompany';
export declare const UnarchiveCompany: UnarchiveCompanyType;
export declare const UnarchiveCompanySchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.UnarchiveCompany">;
    companyUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.UnarchiveCompany";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Organization.UnarchiveCompany";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type UnarchiveCompany = z.infer<typeof UnarchiveCompanySchema>;
export declare const UnarchiveCompanyFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Organization.UnarchiveCompany";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.UnarchiveCompany">;
    companyUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.UnarchiveCompany";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Organization.UnarchiveCompany";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
