"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteOrganizationTagFactory = exports.DeleteOrganizationTagSchema = exports.DeleteOrganizationTag = exports.ArchiveOrganizationTag = exports.UpdateOrganizationTagFactory = exports.UpdateOrganizationTagSchema = exports.UpdateOrganizationTag = exports.CreateOrganizationTagFactory = exports.CreateOrganizationTagSchema = exports.CreateOrganizationTag = exports.OrganizationTagSchema = void 0;
const ICommand_1 = require("../../ICommand");
const zod_1 = require("zod");
const organizationTagUidSchema_1 = require("./organizationTagUidSchema");
const commandFactory_1 = require("../../commandFactory");
const entityCommands_1 = require("../../Entity/entityCommands");
exports.OrganizationTagSchema = entityCommands_1.EntitySchema.extend({
    name: zod_1.z.string(),
    organizationUid: zod_1.z.string(),
    color: zod_1.z.string().optional(),
    parentTagUid: zod_1.z.string().optional(),
});
exports.CreateOrganizationTag = 'Organization.Tag.CreateOrganizationTag';
// TODO: use next line when all commands are being sent in new format
// export const CreateOrganizationTagSchema = createCreateEntityCommandSchema(CreateOrganizationTag, OrganizationTagSchema);
exports.CreateOrganizationTagSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.CreateOrganizationTag),
    uid: organizationTagUidSchema_1.OrganizationTagUIDSchema,
    name: zod_1.z.string(),
    organizationUid: zod_1.z.string(),
    color: zod_1.z.string().optional(),
    parentTagUid: zod_1.z.string().optional(),
});
exports.CreateOrganizationTagFactory = (0, commandFactory_1.createCommandFactory)(exports.CreateOrganizationTagSchema);
exports.UpdateOrganizationTag = 'Organization.Tag.UpdateOrganizationTag';
exports.UpdateOrganizationTagSchema = (0, entityCommands_1.createUpdateEntityCommandSchema)(exports.UpdateOrganizationTag, exports.OrganizationTagSchema);
exports.UpdateOrganizationTagFactory = (0, commandFactory_1.createCommandFactory)(exports.UpdateOrganizationTagSchema);
exports.ArchiveOrganizationTag = 'Organization.Tag.ArchiveOrganizationTag';
exports.DeleteOrganizationTag = 'Organization.Tag.DeleteOrganizationTag';
exports.DeleteOrganizationTagSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.DeleteOrganizationTag),
    uid: organizationTagUidSchema_1.OrganizationTagUIDSchema,
});
exports.DeleteOrganizationTagFactory = (0, commandFactory_1.createCommandFactory)(exports.DeleteOrganizationTagSchema);
//# sourceMappingURL=organizationTagCommands.js.map