import { IOriginatorAwareCommand } from '../../ICommand';
import { z } from 'zod';
export declare const OrganizationTagSchema: z.ZodObject<{
    uid: z.ZodString;
    name: z.ZodString;
    organizationUid: z.ZodString;
    color: z.ZodOptional<z.ZodString>;
    parentTagUid: z.ZodOptional<z.ZodString>;
}, "strict", z.ZodTypeAny, {
    name: string;
    organizationUid: string;
    uid: string;
    color?: string | undefined;
    parentTagUid?: string | undefined;
}, {
    name: string;
    organizationUid: string;
    uid: string;
    color?: string | undefined;
    parentTagUid?: string | undefined;
}>;
export type CreateOrganizationTagType = 'Organization.Tag.CreateOrganizationTag';
export declare const CreateOrganizationTag: CreateOrganizationTagType;
export declare const CreateOrganizationTagSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.Tag.CreateOrganizationTag">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    name: z.ZodString;
    organizationUid: z.ZodString;
    color: z.ZodOptional<z.ZodString>;
    parentTagUid: z.ZodOptional<z.ZodString>;
}, "strict", z.ZodTypeAny, {
    name: string;
    type: "Organization.Tag.CreateOrganizationTag";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    color?: string | undefined;
    parentTagUid?: string | undefined;
}, {
    name: string;
    type: "Organization.Tag.CreateOrganizationTag";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    color?: string | undefined;
    parentTagUid?: string | undefined;
}>;
export type CreateOrganizationTag = z.infer<typeof CreateOrganizationTagSchema>;
export declare const CreateOrganizationTagFactory: (data: {
    color?: string | undefined;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    parentTagUid?: string | undefined;
} & {
    name: string;
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    name: string;
    type: "Organization.Tag.CreateOrganizationTag";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    color?: string | undefined;
    parentTagUid?: string | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.Tag.CreateOrganizationTag">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    name: z.ZodString;
    organizationUid: z.ZodString;
    color: z.ZodOptional<z.ZodString>;
    parentTagUid: z.ZodOptional<z.ZodString>;
}, "strict", z.ZodTypeAny, {
    name: string;
    type: "Organization.Tag.CreateOrganizationTag";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    color?: string | undefined;
    parentTagUid?: string | undefined;
}, {
    name: string;
    type: "Organization.Tag.CreateOrganizationTag";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    color?: string | undefined;
    parentTagUid?: string | undefined;
}>>;
export type UpdateOrganizationTagType = 'Organization.Tag.UpdateOrganizationTag';
export declare const UpdateOrganizationTag: UpdateOrganizationTagType;
export declare const UpdateOrganizationTagSchema: import("../../Entity/entityCommands").UpdateEntityCommandSchema<"Organization.Tag.UpdateOrganizationTag", {
    uid: z.ZodString;
    name: z.ZodString;
    organizationUid: z.ZodString;
    color: z.ZodOptional<z.ZodString>;
    parentTagUid: z.ZodOptional<z.ZodString>;
}>;
export type UpdateOrganizationTag = z.infer<typeof UpdateOrganizationTagSchema>;
export declare const UpdateOrganizationTagFactory: (data: {
    name?: string | undefined;
    color?: string | null | undefined;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    organizationUid?: string | undefined;
    parentTagUid?: string | null | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Organization.Tag.UpdateOrganizationTag";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    name?: string | undefined;
    organizationUid?: string | undefined;
    color?: string | null | undefined;
    parentTagUid?: string | null | undefined;
}, {}, Function>>) => z.TypeOf<import("../../Entity/entityCommands").UpdateEntityCommandSchema<"Organization.Tag.UpdateOrganizationTag", {
    uid: z.ZodString;
    name: z.ZodString;
    organizationUid: z.ZodString;
    color: z.ZodOptional<z.ZodString>;
    parentTagUid: z.ZodOptional<z.ZodString>;
}>>;
/**
 * @deprecated Use `DeleteOrganizationTag` instead
 */
export type ArchiveOrganizationTagType = 'Organization.Tag.ArchiveOrganizationTag';
export declare const ArchiveOrganizationTag: ArchiveOrganizationTagType;
export interface ArchiveOrganizationTag extends IOriginatorAwareCommand<ArchiveOrganizationTagType> {
    uid: string;
}
export declare const DeleteOrganizationTag = "Organization.Tag.DeleteOrganizationTag";
export declare const DeleteOrganizationTagSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.Tag.DeleteOrganizationTag">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.Tag.DeleteOrganizationTag";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Organization.Tag.DeleteOrganizationTag";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type DeleteOrganizationTag = z.infer<typeof DeleteOrganizationTagSchema>;
export declare const DeleteOrganizationTagFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Organization.Tag.DeleteOrganizationTag";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.Tag.DeleteOrganizationTag">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.Tag.DeleteOrganizationTag";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Organization.Tag.DeleteOrganizationTag";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
