import { z } from 'zod';
import { LocationMarker } from '@signageos/common-types/dist/Location/location';
export declare const LocationUidSchema: z.ZodUnion<[z.ZodString, z.ZodString]>;
export declare const FeatureSchema: z.ZodObject<{
    type: z.ZodLiteral<"Feature">;
    geometry: z.ZodObject<{
        type: z.ZodLiteral<"Point">;
        coordinates: z.ZodArray<z.ZodNumber, "many">;
        bbox: z.ZodOptional<z.ZodUnion<[z.ZodTuple<[z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber], null>, z.ZodTuple<[z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber], null>]>>;
        interpolated: z.ZodOptional<z.ZodBoolean>;
        omitted: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        type: "Point";
        coordinates: number[];
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        interpolated?: boolean | undefined;
        omitted?: boolean | undefined;
    }, {
        type: "Point";
        coordinates: number[];
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        interpolated?: boolean | undefined;
        omitted?: boolean | undefined;
    }>;
    id: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodString]>>;
    properties: z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodAny>>;
    bbox: z.ZodOptional<z.ZodUnion<[z.ZodTuple<[z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber], null>, z.ZodTuple<[z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber], null>]>>;
    label: z.ZodOptional<z.ZodString>;
    value: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "Feature";
    geometry: {
        type: "Point";
        coordinates: number[];
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        interpolated?: boolean | undefined;
        omitted?: boolean | undefined;
    };
    properties: Record<string, any> | null;
    id?: string | number | undefined;
    bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
    label?: string | undefined;
    value?: string | undefined;
}, {
    type: "Feature";
    geometry: {
        type: "Point";
        coordinates: number[];
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        interpolated?: boolean | undefined;
        omitted?: boolean | undefined;
    };
    properties: Record<string, any> | null;
    id?: string | number | undefined;
    bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
    label?: string | undefined;
    value?: string | undefined;
}>;
export declare const CreateLocation = "Location.CreateLocation";
export declare const CreateLocationSchema: z.ZodObject<{
    type: z.ZodLiteral<"Location.CreateLocation">;
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    name: z.ZodString;
    feature: z.ZodObject<{
        type: z.ZodLiteral<"Feature">;
        geometry: z.ZodObject<{
            type: z.ZodLiteral<"Point">;
            coordinates: z.ZodArray<z.ZodNumber, "many">;
            bbox: z.ZodOptional<z.ZodUnion<[z.ZodTuple<[z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber], null>, z.ZodTuple<[z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber], null>]>>;
            interpolated: z.ZodOptional<z.ZodBoolean>;
            omitted: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        }, {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        }>;
        id: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodString]>>;
        properties: z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodAny>>;
        bbox: z.ZodOptional<z.ZodUnion<[z.ZodTuple<[z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber], null>, z.ZodTuple<[z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber], null>]>>;
        label: z.ZodOptional<z.ZodString>;
        value: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        type: "Feature";
        geometry: {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        };
        properties: Record<string, any> | null;
        id?: string | number | undefined;
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        label?: string | undefined;
        value?: string | undefined;
    }, {
        type: "Feature";
        geometry: {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        };
        properties: Record<string, any> | null;
        id?: string | number | undefined;
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        label?: string | undefined;
        value?: string | undefined;
    }>;
    organizationUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    city: z.ZodString;
    countryCode: z.ZodString;
    customId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    attachments: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    description: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    tagUids: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodString]>, "many">>;
    mapMarker: z.ZodOptional<z.ZodUnion<[z.ZodNativeEnum<typeof LocationMarker>, z.ZodNull]>>;
}, "strict", z.ZodTypeAny, {
    name: string;
    type: "Location.CreateLocation";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    feature: {
        type: "Feature";
        geometry: {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        };
        properties: Record<string, any> | null;
        id?: string | number | undefined;
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        label?: string | undefined;
        value?: string | undefined;
    };
    city: string;
    countryCode: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    customId?: string | null | undefined;
    attachments?: string[] | undefined;
    description?: string | null | undefined;
    tagUids?: string[] | undefined;
    mapMarker?: LocationMarker | null | undefined;
}, {
    name: string;
    type: "Location.CreateLocation";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    feature: {
        type: "Feature";
        geometry: {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        };
        properties: Record<string, any> | null;
        id?: string | number | undefined;
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        label?: string | undefined;
        value?: string | undefined;
    };
    city: string;
    countryCode: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    customId?: string | null | undefined;
    attachments?: string[] | undefined;
    description?: string | null | undefined;
    tagUids?: string[] | undefined;
    mapMarker?: LocationMarker | null | undefined;
}>;
export type CreateLocation = z.infer<typeof CreateLocationSchema>;
export declare const CreateLocationFactory: (data: {
    description?: string | null | undefined;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    tagUids?: string[] | undefined;
    customId?: string | null | undefined;
    attachments?: string[] | undefined;
    mapMarker?: LocationMarker | null | undefined;
} & {
    name: string;
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    feature: {
        type: "Feature";
        geometry: {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        };
        properties: Record<string, any> | null;
        id?: string | number | undefined;
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        label?: string | undefined;
        value?: string | undefined;
    };
    city: string;
    countryCode: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    name: string;
    type: "Location.CreateLocation";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    feature: {
        type: "Feature";
        geometry: {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        };
        properties: Record<string, any> | null;
        id?: string | number | undefined;
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        label?: string | undefined;
        value?: string | undefined;
    };
    city: string;
    countryCode: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    customId?: string | null | undefined;
    attachments?: string[] | undefined;
    description?: string | null | undefined;
    tagUids?: string[] | undefined;
    mapMarker?: LocationMarker | null | undefined;
}, {
    uid: () => string;
}, Function>>) => z.TypeOf<z.ZodObject<{
    type: z.ZodLiteral<"Location.CreateLocation">;
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    name: z.ZodString;
    feature: z.ZodObject<{
        type: z.ZodLiteral<"Feature">;
        geometry: z.ZodObject<{
            type: z.ZodLiteral<"Point">;
            coordinates: z.ZodArray<z.ZodNumber, "many">;
            bbox: z.ZodOptional<z.ZodUnion<[z.ZodTuple<[z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber], null>, z.ZodTuple<[z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber], null>]>>;
            interpolated: z.ZodOptional<z.ZodBoolean>;
            omitted: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        }, {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        }>;
        id: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodString]>>;
        properties: z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodAny>>;
        bbox: z.ZodOptional<z.ZodUnion<[z.ZodTuple<[z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber], null>, z.ZodTuple<[z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber], null>]>>;
        label: z.ZodOptional<z.ZodString>;
        value: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        type: "Feature";
        geometry: {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        };
        properties: Record<string, any> | null;
        id?: string | number | undefined;
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        label?: string | undefined;
        value?: string | undefined;
    }, {
        type: "Feature";
        geometry: {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        };
        properties: Record<string, any> | null;
        id?: string | number | undefined;
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        label?: string | undefined;
        value?: string | undefined;
    }>;
    organizationUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    city: z.ZodString;
    countryCode: z.ZodString;
    customId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    attachments: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    description: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    tagUids: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodString]>, "many">>;
    mapMarker: z.ZodOptional<z.ZodUnion<[z.ZodNativeEnum<typeof LocationMarker>, z.ZodNull]>>;
}, "strict", z.ZodTypeAny, {
    name: string;
    type: "Location.CreateLocation";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    feature: {
        type: "Feature";
        geometry: {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        };
        properties: Record<string, any> | null;
        id?: string | number | undefined;
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        label?: string | undefined;
        value?: string | undefined;
    };
    city: string;
    countryCode: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    customId?: string | null | undefined;
    attachments?: string[] | undefined;
    description?: string | null | undefined;
    tagUids?: string[] | undefined;
    mapMarker?: LocationMarker | null | undefined;
}, {
    name: string;
    type: "Location.CreateLocation";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    feature: {
        type: "Feature";
        geometry: {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        };
        properties: Record<string, any> | null;
        id?: string | number | undefined;
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        label?: string | undefined;
        value?: string | undefined;
    };
    city: string;
    countryCode: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    customId?: string | null | undefined;
    attachments?: string[] | undefined;
    description?: string | null | undefined;
    tagUids?: string[] | undefined;
    mapMarker?: LocationMarker | null | undefined;
}>>;
export declare const UpdateLocation = "Location.UpdateLocation";
export declare const UpdateLocationSchema: z.ZodObject<{
    type: z.ZodLiteral<"Location.UpdateLocation">;
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    name: z.ZodOptional<z.ZodString>;
    feature: z.ZodOptional<z.ZodObject<{
        type: z.ZodLiteral<"Feature">;
        geometry: z.ZodObject<{
            type: z.ZodLiteral<"Point">;
            coordinates: z.ZodArray<z.ZodNumber, "many">;
            bbox: z.ZodOptional<z.ZodUnion<[z.ZodTuple<[z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber], null>, z.ZodTuple<[z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber], null>]>>;
            interpolated: z.ZodOptional<z.ZodBoolean>;
            omitted: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        }, {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        }>;
        id: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodString]>>;
        properties: z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodAny>>;
        bbox: z.ZodOptional<z.ZodUnion<[z.ZodTuple<[z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber], null>, z.ZodTuple<[z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber], null>]>>;
        label: z.ZodOptional<z.ZodString>;
        value: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        type: "Feature";
        geometry: {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        };
        properties: Record<string, any> | null;
        id?: string | number | undefined;
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        label?: string | undefined;
        value?: string | undefined;
    }, {
        type: "Feature";
        geometry: {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        };
        properties: Record<string, any> | null;
        id?: string | number | undefined;
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        label?: string | undefined;
        value?: string | undefined;
    }>>;
    organizationUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
    city: z.ZodOptional<z.ZodString>;
    countryCode: z.ZodOptional<z.ZodString>;
    customId: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodString>>>;
    attachments: z.ZodOptional<z.ZodOptional<z.ZodArray<z.ZodString, "many">>>;
    description: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodString>>>;
    tagUids: z.ZodOptional<z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodString]>, "many">>>;
    mapMarker: z.ZodOptional<z.ZodOptional<z.ZodUnion<[z.ZodNativeEnum<typeof LocationMarker>, z.ZodNull]>>>;
}, "strict", z.ZodTypeAny, {
    type: "Location.UpdateLocation";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    name?: string | undefined;
    feature?: {
        type: "Feature";
        geometry: {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        };
        properties: Record<string, any> | null;
        id?: string | number | undefined;
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        label?: string | undefined;
        value?: string | undefined;
    } | undefined;
    organizationUid?: string | undefined;
    city?: string | undefined;
    countryCode?: string | undefined;
    customId?: string | null | undefined;
    attachments?: string[] | undefined;
    description?: string | null | undefined;
    tagUids?: string[] | undefined;
    mapMarker?: LocationMarker | null | undefined;
}, {
    type: "Location.UpdateLocation";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    name?: string | undefined;
    feature?: {
        type: "Feature";
        geometry: {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        };
        properties: Record<string, any> | null;
        id?: string | number | undefined;
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        label?: string | undefined;
        value?: string | undefined;
    } | undefined;
    organizationUid?: string | undefined;
    city?: string | undefined;
    countryCode?: string | undefined;
    customId?: string | null | undefined;
    attachments?: string[] | undefined;
    description?: string | null | undefined;
    tagUids?: string[] | undefined;
    mapMarker?: LocationMarker | null | undefined;
}>;
export type UpdateLocation = z.infer<typeof UpdateLocationSchema>;
export declare const UpdateLocationFactory: (data: {
    name?: string | undefined;
    description?: string | null | undefined;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    organizationUid?: string | undefined;
    tagUids?: string[] | undefined;
    feature?: {
        type: "Feature";
        geometry: {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        };
        properties: Record<string, any> | null;
        id?: string | number | undefined;
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        label?: string | undefined;
        value?: string | undefined;
    } | undefined;
    city?: string | undefined;
    countryCode?: string | undefined;
    customId?: string | null | undefined;
    attachments?: string[] | undefined;
    mapMarker?: LocationMarker | null | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Location.UpdateLocation";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    name?: string | undefined;
    feature?: {
        type: "Feature";
        geometry: {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        };
        properties: Record<string, any> | null;
        id?: string | number | undefined;
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        label?: string | undefined;
        value?: string | undefined;
    } | undefined;
    organizationUid?: string | undefined;
    city?: string | undefined;
    countryCode?: string | undefined;
    customId?: string | null | undefined;
    attachments?: string[] | undefined;
    description?: string | null | undefined;
    tagUids?: string[] | undefined;
    mapMarker?: LocationMarker | null | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    type: z.ZodLiteral<"Location.UpdateLocation">;
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    name: z.ZodOptional<z.ZodString>;
    feature: z.ZodOptional<z.ZodObject<{
        type: z.ZodLiteral<"Feature">;
        geometry: z.ZodObject<{
            type: z.ZodLiteral<"Point">;
            coordinates: z.ZodArray<z.ZodNumber, "many">;
            bbox: z.ZodOptional<z.ZodUnion<[z.ZodTuple<[z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber], null>, z.ZodTuple<[z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber], null>]>>;
            interpolated: z.ZodOptional<z.ZodBoolean>;
            omitted: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        }, {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        }>;
        id: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodString]>>;
        properties: z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodAny>>;
        bbox: z.ZodOptional<z.ZodUnion<[z.ZodTuple<[z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber], null>, z.ZodTuple<[z.ZodNumber, z.ZodNumber, z.ZodNumber, z.ZodNumber], null>]>>;
        label: z.ZodOptional<z.ZodString>;
        value: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        type: "Feature";
        geometry: {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        };
        properties: Record<string, any> | null;
        id?: string | number | undefined;
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        label?: string | undefined;
        value?: string | undefined;
    }, {
        type: "Feature";
        geometry: {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        };
        properties: Record<string, any> | null;
        id?: string | number | undefined;
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        label?: string | undefined;
        value?: string | undefined;
    }>>;
    organizationUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
    city: z.ZodOptional<z.ZodString>;
    countryCode: z.ZodOptional<z.ZodString>;
    customId: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodString>>>;
    attachments: z.ZodOptional<z.ZodOptional<z.ZodArray<z.ZodString, "many">>>;
    description: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodString>>>;
    tagUids: z.ZodOptional<z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodString]>, "many">>>;
    mapMarker: z.ZodOptional<z.ZodOptional<z.ZodUnion<[z.ZodNativeEnum<typeof LocationMarker>, z.ZodNull]>>>;
}, "strict", z.ZodTypeAny, {
    type: "Location.UpdateLocation";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    name?: string | undefined;
    feature?: {
        type: "Feature";
        geometry: {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        };
        properties: Record<string, any> | null;
        id?: string | number | undefined;
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        label?: string | undefined;
        value?: string | undefined;
    } | undefined;
    organizationUid?: string | undefined;
    city?: string | undefined;
    countryCode?: string | undefined;
    customId?: string | null | undefined;
    attachments?: string[] | undefined;
    description?: string | null | undefined;
    tagUids?: string[] | undefined;
    mapMarker?: LocationMarker | null | undefined;
}, {
    type: "Location.UpdateLocation";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    name?: string | undefined;
    feature?: {
        type: "Feature";
        geometry: {
            type: "Point";
            coordinates: number[];
            bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
            interpolated?: boolean | undefined;
            omitted?: boolean | undefined;
        };
        properties: Record<string, any> | null;
        id?: string | number | undefined;
        bbox?: [number, number, number, number, number, number] | [number, number, number, number] | undefined;
        label?: string | undefined;
        value?: string | undefined;
    } | undefined;
    organizationUid?: string | undefined;
    city?: string | undefined;
    countryCode?: string | undefined;
    customId?: string | null | undefined;
    attachments?: string[] | undefined;
    description?: string | null | undefined;
    tagUids?: string[] | undefined;
    mapMarker?: LocationMarker | null | undefined;
}>>;
export declare const ArchiveLocation = "Location.ArchiveLocation";
export declare const ArchiveLocationSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Location.ArchiveLocation">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "Location.ArchiveLocation";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Location.ArchiveLocation";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type ArchiveLocation = z.infer<typeof ArchiveLocationSchema>;
export declare const ArchiveLocationFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Location.ArchiveLocation";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Location.ArchiveLocation">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "Location.ArchiveLocation";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Location.ArchiveLocation";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const UnarchiveLocation = "Location.UnarchiveLocation";
export declare const UnarchiveLocationSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Location.UnarchiveLocation">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "Location.UnarchiveLocation";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Location.UnarchiveLocation";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type UnarchiveLocation = z.infer<typeof UnarchiveLocationSchema>;
export declare const UnarchiveLocationFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Location.UnarchiveLocation";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Location.UnarchiveLocation">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "Location.UnarchiveLocation";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Location.UnarchiveLocation";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const DeleteLocation = "Location.DeleteLocation";
export declare const DeleteLocationSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Location.DeleteLocation">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "Location.DeleteLocation";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Location.DeleteLocation";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type DeleteLocation = z.infer<typeof DeleteLocationSchema>;
export declare const DeleteLocationFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Location.DeleteLocation";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Location.DeleteLocation">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "Location.DeleteLocation";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Location.DeleteLocation";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
