"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OriginatorAwareCommandSchema = exports.OriginatorSchema = exports.BaseCommandSchema = void 0;
const zod_1 = require("zod");
const context_1 = require("./Context/context");
exports.BaseCommandSchema = zod_1.z.strictObject({}).extend(context_1.ContextAwareCommandSchema.shape);
exports.OriginatorSchema = zod_1.z.strictObject({
    accountId: zod_1.z.number().optional(),
    organizationUid: zod_1.z.string().optional(),
});
exports.OriginatorAwareCommandSchema = exports.BaseCommandSchema.extend({
    originator: exports.OriginatorSchema,
}).strict();
//# sourceMappingURL=ICommand.js.map