"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RemoveExtendedManagementDevicesFactory = exports.RemoveExtendedManagementDevicesSchema = exports.RemoveExtendedManagementDevices = exports.UpsertExtendedManagementDevicesFactory = exports.UpsertExtendedManagementDevicesSchema = exports.UpsertExtendedManagementDevices = void 0;
const commandFactory_1 = require("../commandFactory");
const zod_1 = require("zod");
const deviceCommands_1 = require("./deviceCommands");
const ICommand_1 = require("../ICommand");
exports.UpsertExtendedManagementDevices = 'Device.UpsertExtendedManagementDevices';
exports.UpsertExtendedManagementDevicesSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.UpsertExtendedManagementDevices),
    devices: zod_1.z.array(zod_1.z.strictObject({
        deviceUid: deviceCommands_1.DeviceUidSchema,
        /** Used later on to pair not registered device with company/organization or another entity */
        pairCode: zod_1.z.string().max(50),
    })),
}).strict();
exports.UpsertExtendedManagementDevicesFactory = (0, commandFactory_1.createCommandFactory)(exports.UpsertExtendedManagementDevicesSchema);
exports.RemoveExtendedManagementDevices = 'Device.RemoveExtendedManagementDevices';
exports.RemoveExtendedManagementDevicesSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.RemoveExtendedManagementDevices),
    deviceUids: zod_1.z.array(deviceCommands_1.DeviceUidSchema),
}).strict();
exports.RemoveExtendedManagementDevicesFactory = (0, commandFactory_1.createCommandFactory)(exports.RemoveExtendedManagementDevicesSchema);
//# sourceMappingURL=deviceExtendedManagementCommands.js.map