import { z } from 'zod';
export declare const UpsertExtendedManagementDevices = "Device.UpsertExtendedManagementDevices";
export declare const UpsertExtendedManagementDevicesSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.UpsertExtendedManagementDevices">;
    devices: z.ZodArray<z.ZodObject<{
        deviceUid: z.ZodString;
        /** Used later on to pair not registered device with company/organization or another entity */
        pairCode: z.ZodString;
    }, "strict", z.ZodTypeAny, {
        deviceUid: string;
        pairCode: string;
    }, {
        deviceUid: string;
        pairCode: string;
    }>, "many">;
}, "strict", z.ZodTypeAny, {
    type: "Device.UpsertExtendedManagementDevices";
    devices: {
        deviceUid: string;
        pairCode: string;
    }[];
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.UpsertExtendedManagementDevices";
    devices: {
        deviceUid: string;
        pairCode: string;
    }[];
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
/**
 * This command will update the current state of extended management devices.
 * If device is already extended, skip it. If not, add it to list of extended management devices.
 */
export type UpsertExtendedManagementDevices = z.infer<typeof UpsertExtendedManagementDevicesSchema>;
export declare const UpsertExtendedManagementDevicesFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    devices: {
        deviceUid: string;
        pairCode: string;
    }[];
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Device.UpsertExtendedManagementDevices";
    devices: {
        deviceUid: string;
        pairCode: string;
    }[];
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.UpsertExtendedManagementDevices">;
    devices: z.ZodArray<z.ZodObject<{
        deviceUid: z.ZodString;
        /** Used later on to pair not registered device with company/organization or another entity */
        pairCode: z.ZodString;
    }, "strict", z.ZodTypeAny, {
        deviceUid: string;
        pairCode: string;
    }, {
        deviceUid: string;
        pairCode: string;
    }>, "many">;
}, "strict", z.ZodTypeAny, {
    type: "Device.UpsertExtendedManagementDevices";
    devices: {
        deviceUid: string;
        pairCode: string;
    }[];
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.UpsertExtendedManagementDevices";
    devices: {
        deviceUid: string;
        pairCode: string;
    }[];
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const RemoveExtendedManagementDevices = "Device.RemoveExtendedManagementDevices";
export declare const RemoveExtendedManagementDevicesSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.RemoveExtendedManagementDevices">;
    deviceUids: z.ZodArray<z.ZodString, "many">;
}, "strict", z.ZodTypeAny, {
    type: "Device.RemoveExtendedManagementDevices";
    deviceUids: string[];
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.RemoveExtendedManagementDevices";
    deviceUids: string[];
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
/**
 * The opposite of upserting extended management devices.
 * It will update state and remove all devices provided here from extended management device list.
 * If device is not kept in this list, ignore it.
 */
export type RemoveExtendedManagementDevices = z.infer<typeof RemoveExtendedManagementDevicesSchema>;
export declare const RemoveExtendedManagementDevicesFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    deviceUids: string[];
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Device.RemoveExtendedManagementDevices";
    deviceUids: string[];
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.RemoveExtendedManagementDevices">;
    deviceUids: z.ZodArray<z.ZodString, "many">;
}, "strict", z.ZodTypeAny, {
    type: "Device.RemoveExtendedManagementDevices";
    deviceUids: string[];
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.RemoveExtendedManagementDevices";
    deviceUids: string[];
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
