"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PairDeviceWithOrganization = exports.PairDeviceVerificationWithOrganizationFactory = exports.PairDeviceVerificationWithOrganizationSchema = exports.PairDeviceVerificationWithOrganization = exports.HandleDeviceHashCreated = exports.HandleDeviceVerificationHashCreatedFactory = exports.HandleDeviceVerificationHashCreatedSchema = exports.HandleDeviceVerificationHashCreated = exports.PairDevice = exports.PairDeviceVerificationFactory = exports.PairDeviceVerificationSchema = exports.PairDeviceVerification = exports.DeviceVerificationHashSchema = void 0;
const commandFactory_1 = require("../../commandFactory");
const zod_1 = require("zod");
const ICommand_1 = require("../../ICommand");
const subscription_1 = require("@signageos/common-types/dist/Subscription/subscription");
exports.DeviceVerificationHashSchema = zod_1.z
    .string()
    .max(7)
    .refine((value) => {
    const verificationHashRegex = /^[a-f0-9]{6}$/;
    return verificationHashRegex.test(value);
});
exports.PairDeviceVerification = 'Device.Verification.PairDevice';
exports.PairDeviceVerificationSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.PairDeviceVerification),
    verificationHash: exports.DeviceVerificationHashSchema,
    subscriptionType: zod_1.z.nativeEnum(subscription_1.SubscriptionType),
    originator: zod_1.z
        .strictObject({
        accountId: zod_1.z.number().optional(),
        organizationUid: zod_1.z.string().optional(),
    })
        .optional(),
});
exports.PairDeviceVerificationFactory = (0, commandFactory_1.createCommandFactory)(exports.PairDeviceVerificationSchema);
/**
 * @deprecated Use PairDeviceVerification instead.
 */
exports.PairDevice = exports.PairDeviceVerification;
exports.HandleDeviceVerificationHashCreated = 'Device.Verification.HandleVerificationHashCreated';
exports.HandleDeviceVerificationHashCreatedSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.HandleDeviceVerificationHashCreated),
    deviceUid: zod_1.z.string(),
    verificationHash: exports.DeviceVerificationHashSchema,
    originator: zod_1.z
        .strictObject({
        accountId: zod_1.z.number().optional(),
        organizationUid: zod_1.z.string().optional(),
    })
        .optional(),
});
exports.HandleDeviceVerificationHashCreatedFactory = (0, commandFactory_1.createCommandFactory)(exports.HandleDeviceVerificationHashCreatedSchema);
/**
 * @deprecated Use HandleDeviceVerificationHashCreated instead.
 */
exports.HandleDeviceHashCreated = exports.HandleDeviceVerificationHashCreated;
exports.PairDeviceVerificationWithOrganization = 'Device.PairDeviceWithOrganization';
/**
 * @property policyWithPriority The specific device policy can be optionally set to the device during verification.
 */
exports.PairDeviceVerificationWithOrganizationSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.PairDeviceVerificationWithOrganization),
    verificationHash: exports.DeviceVerificationHashSchema,
    organizationUid: zod_1.z.string(),
    subscriptionType: zod_1.z.nativeEnum(subscription_1.SubscriptionType),
    deviceName: zod_1.z.string().optional(),
    policyWithPriority: zod_1.z
        .object({
        policyUid: zod_1.z.string(),
        priority: zod_1.z.number(),
    })
        .optional(),
    originator: zod_1.z
        .strictObject({
        accountId: zod_1.z.number().optional(),
        organizationUid: zod_1.z.string().optional(),
    })
        .optional(),
});
exports.PairDeviceVerificationWithOrganizationFactory = (0, commandFactory_1.createCommandFactory)(exports.PairDeviceVerificationWithOrganizationSchema);
/**
 * @deprecated Use PairDeviceVerificationWithOrganization instead.
 */
exports.PairDeviceWithOrganization = exports.PairDeviceVerificationWithOrganization;
//# sourceMappingURL=deviceVerificationCommands.js.map