import IBaseCommand from '../../ICommand';
import TimerType from './TimerType';
import { TimerLevel } from '@signageos/common-types/dist/Device/Timer/TimerLevel';
import { IMarkSetDevicePropertyDone, ISetDeviceProperty } from '../deviceCommands';
import { ShortWeekdayEnum } from '@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum';
export type SetDeviceTimerSettingsType = 'Device.Timer.SetDeviceTimerSettings';
export declare const SetDeviceTimerSettings: SetDeviceTimerSettingsType;
export interface SetDeviceTimerSettings extends ISetDeviceProperty<SetDeviceTimerSettingsType> {
    timerType: TimerType;
    volume: number;
    weekdays: `${ShortWeekdayEnum}`[];
    level: TimerLevel;
    timeOn: string | null;
    timeOff: string | null;
}
export type MarkSetDeviceTimerSettingsSucceededType = 'Device.Timer.MarkSetDeviceTimerSettingsSucceeded';
export declare const MarkSetDeviceTimerSettingsSucceeded: MarkSetDeviceTimerSettingsSucceededType;
export type MarkSetDeviceTimerSettingsSucceeded = IMarkSetDevicePropertyDone<MarkSetDeviceTimerSettingsSucceededType>;
export type MarkSetDeviceTimerSettingsFailedType = 'Device.Timer.MarkSetDeviceTimerSettingsFailed';
export declare const MarkSetDeviceTimerSettingsFailed: MarkSetDeviceTimerSettingsFailedType;
export type MarkSetDeviceTimerSettingsFailed = IMarkSetDevicePropertyDone<MarkSetDeviceTimerSettingsFailedType>;
export declare const PostponeSetDeviceTimerSettings = "Device.Timer.PostponeSetDeviceTimerSettings";
export interface PostponeSetDeviceTimerSettings extends IBaseCommand<typeof PostponeSetDeviceTimerSettings> {
    uid: string;
    duid: string;
}
