import ICommand, { IOriginatorAwareCommand } from '../../ICommand';
import { ISetDeviceProperty } from '../deviceCommands';
export interface ItemResult {
    title: string;
    skipped: boolean;
    failed: boolean;
    duration: number;
    reason?: string;
}
export interface TestCaseResult {
    beforeEach: ItemResult[];
    test: ItemResult;
    afterEach: ItemResult[];
}
export interface TestResult {
    title: string;
    total: number;
    successful: number;
    skipped: number;
    failed: number;
    duration: number;
    describe: TestResult[];
    test: TestCaseResult[];
    before: ItemResult[];
    after: ItemResult[];
}
export declare const StartTestSuite = "Device.Test.StartTestSuite";
export interface StartTestSuite extends ISetDeviceProperty<typeof StartTestSuite> {
    tests?: string[];
}
export declare const MarkStartTestSuiteFailed = "Device.Test.MarkStartTestSuiteFailed";
export interface MarkStartTestSuiteFailed extends ICommand<typeof MarkStartTestSuiteFailed> {
    uid: string;
}
export declare const MarkTestSuiteCanceled = "Device.Test.MarkTestSuiteCanceled";
export interface MarkTestSuiteCanceled extends IOriginatorAwareCommand<typeof MarkTestSuiteCanceled> {
    uid: string;
}
export declare const MarkTestSucceeded = "Device.Test.MarkTestSucceeded";
export interface MarkTestSucceeded extends ICommand<typeof MarkTestSucceeded> {
    uid: string;
    identifier: string;
    result?: TestResult;
}
export declare const MarkTestFailed = "Device.Test.MarkTestFailed";
export interface MarkTestFailed extends ICommand<typeof MarkTestFailed> {
    uid: string;
    identifier: string;
    result?: TestResult;
}
export declare const MarkTestSkipped = "Device.Test.MarkTestSkipped";
export interface MarkTestSkipped extends ICommand<typeof MarkTestSkipped> {
    uid: string;
    identifier: string;
    result?: TestResult;
}
