import { z } from 'zod';
export declare const SetRemoteServer = "Device.RemoteServer.SetRemoteServer";
export declare const SetRemoteServerSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.RemoteServer.SetRemoteServer">;
    rmServerUrl: z.ZodNullable<z.ZodString>;
}, "strict", z.ZodTypeAny, {
    type: "Device.RemoteServer.SetRemoteServer";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    rmServerUrl: string | null;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.RemoteServer.SetRemoteServer";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    rmServerUrl: string | null;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type SetRemoteServer = z.infer<typeof SetRemoteServerSchema>;
export declare const MarkSetRemoteServerSucceeded = "Device.RemoteServer.SetRemoteServerSucceeded";
export declare const MarkSetRemoteServerSucceededSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.RemoteServer.SetRemoteServerSucceeded">;
}, "strict", z.ZodTypeAny, {
    type: "Device.RemoteServer.SetRemoteServerSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.RemoteServer.SetRemoteServerSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type MarkSetRemoteServerSucceeded = z.infer<typeof MarkSetRemoteServerSucceededSchema>;
export declare const MarkSetRemoteServerFailed = "Device.RemoteServer.SetRemoteServerFailed";
export declare const MarkSetRemoteServerFailedSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.RemoteServer.SetRemoteServerFailed">;
}, "strict", z.ZodTypeAny, {
    type: "Device.RemoteServer.SetRemoteServerFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.RemoteServer.SetRemoteServerFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type MarkSetRemoteServerFailed = z.infer<typeof MarkSetRemoteServerFailedSchema>;
