import { z } from 'zod';
export declare const CreateDeviceProvisioningRecipe = "Device.ProvisioningRecipe.CreateDeviceProvisioningRecipe";
export declare const CreateDeviceProvisioningRecipeSchema: import("../../Entity/entityCommands").CreateEntityCommandSchema<"Device.ProvisioningRecipe.CreateDeviceProvisioningRecipe", {
    uid: z.ZodString;
    organizationUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    serialNumber: z.ZodOptional<z.ZodString>;
    model: z.ZodOptional<z.ZodString>;
    macAddress: z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>>;
    brand: z.ZodString;
    tagUids: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodString]>, "many">>;
    deviceName: z.ZodOptional<z.ZodString>;
    policyUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
    locationUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
}>;
export type CreateDeviceProvisioningRecipe = z.infer<typeof CreateDeviceProvisioningRecipeSchema>;
export declare const CreateDeviceProvisioningRecipeFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    model?: string | undefined;
    serialNumber?: string | undefined;
    tagUids?: string[] | undefined;
    macAddress?: string | undefined;
    deviceName?: string | undefined;
    policyUid?: string | undefined;
    locationUid?: string | undefined;
} & {
    brand: string;
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.ProvisioningRecipe.CreateDeviceProvisioningRecipe";
    brand: string;
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    serialNumber?: string | undefined;
    model?: string | undefined;
    macAddress?: string | undefined;
    tagUids?: string[] | undefined;
    deviceName?: string | undefined;
    policyUid?: string | undefined;
    locationUid?: string | undefined;
}, {
    uid: () => string;
}, Function>>) => z.TypeOf<import("../../Entity/entityCommands").CreateEntityCommandSchema<"Device.ProvisioningRecipe.CreateDeviceProvisioningRecipe", {
    uid: z.ZodString;
    organizationUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    serialNumber: z.ZodOptional<z.ZodString>;
    model: z.ZodOptional<z.ZodString>;
    macAddress: z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>>;
    brand: z.ZodString;
    tagUids: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodString]>, "many">>;
    deviceName: z.ZodOptional<z.ZodString>;
    policyUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
    locationUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
}>>;
export declare const CreateDeviceProvisioningRecipes = "Device.ProvisioningRecipe.CreateDeviceProvisioningRecipes";
export declare const CreateDeviceProvisioningRecipesSchema: import("../../Entity/entityCommands").CreateEntitiesCommandSchema<"Device.ProvisioningRecipe.CreateDeviceProvisioningRecipes", {
    uid: z.ZodString;
    organizationUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    serialNumber: z.ZodOptional<z.ZodString>;
    model: z.ZodOptional<z.ZodString>;
    macAddress: z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>>;
    brand: z.ZodString;
    tagUids: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodString]>, "many">>;
    deviceName: z.ZodOptional<z.ZodString>;
    policyUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
    locationUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
}>;
export type CreateDeviceProvisioningRecipes = z.infer<typeof CreateDeviceProvisioningRecipesSchema>;
export declare const CreateDeviceProvisioningRecipesFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    items: {
        brand: string;
        organizationUid: string;
        uid: string;
        serialNumber?: string | undefined;
        model?: string | undefined;
        macAddress?: string | undefined;
        tagUids?: string[] | undefined;
        deviceName?: string | undefined;
        policyUid?: string | undefined;
        locationUid?: string | undefined;
    }[];
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.ProvisioningRecipe.CreateDeviceProvisioningRecipes";
    items: {
        brand: string;
        organizationUid: string;
        uid: string;
        serialNumber?: string | undefined;
        model?: string | undefined;
        macAddress?: string | undefined;
        tagUids?: string[] | undefined;
        deviceName?: string | undefined;
        policyUid?: string | undefined;
        locationUid?: string | undefined;
    }[];
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    uid: () => string;
}, Function>>) => z.TypeOf<import("../../Entity/entityCommands").CreateEntitiesCommandSchema<"Device.ProvisioningRecipe.CreateDeviceProvisioningRecipes", {
    uid: z.ZodString;
    organizationUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    serialNumber: z.ZodOptional<z.ZodString>;
    model: z.ZodOptional<z.ZodString>;
    macAddress: z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>>;
    brand: z.ZodString;
    tagUids: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodString]>, "many">>;
    deviceName: z.ZodOptional<z.ZodString>;
    policyUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
    locationUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
}>>;
export declare const ApplyDeviceProvisioningRecipe = "Device.ProvisioningRecipe.ApplyDeviceProvisioningRecipe";
export declare const ApplyDeviceProvisioningRecipeSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Device.ProvisioningRecipe.ApplyDeviceProvisioningRecipe">;
    uid: z.ZodString;
    deviceUid: z.ZodString;
    verificationHash: z.ZodEffects<z.ZodString, string, string>;
}, "strict", z.ZodTypeAny, {
    type: "Device.ProvisioningRecipe.ApplyDeviceProvisioningRecipe";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceUid: string;
    verificationHash: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.ProvisioningRecipe.ApplyDeviceProvisioningRecipe";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceUid: string;
    verificationHash: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type ApplyDeviceProvisioningRecipe = z.infer<typeof ApplyDeviceProvisioningRecipeSchema>;
export declare const ApplyDeviceProvisioningRecipeFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceUid: string;
    verificationHash: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.ProvisioningRecipe.ApplyDeviceProvisioningRecipe";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceUid: string;
    verificationHash: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Device.ProvisioningRecipe.ApplyDeviceProvisioningRecipe">;
    uid: z.ZodString;
    deviceUid: z.ZodString;
    verificationHash: z.ZodEffects<z.ZodString, string, string>;
}, "strict", z.ZodTypeAny, {
    type: "Device.ProvisioningRecipe.ApplyDeviceProvisioningRecipe";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceUid: string;
    verificationHash: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.ProvisioningRecipe.ApplyDeviceProvisioningRecipe";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceUid: string;
    verificationHash: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const UpdateDeviceProvisioningRecipe = "Device.ProvisioningRecipe.UpdateDeviceProvisioningRecipe";
export declare const UpdateDeviceProvisioningRecipeScheme: import("../../Entity/entityCommands").UpdateEntityCommandSchema<"Device.ProvisioningRecipe.UpdateDeviceProvisioningRecipe", {
    uid: z.ZodString;
    organizationUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    serialNumber: z.ZodOptional<z.ZodString>;
    model: z.ZodOptional<z.ZodString>;
    macAddress: z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>>;
    brand: z.ZodString;
    tagUids: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodString]>, "many">>;
    deviceName: z.ZodOptional<z.ZodString>;
    policyUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
    locationUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
}>;
export type UpdateDeviceProvisioningRecipe = z.infer<typeof UpdateDeviceProvisioningRecipeScheme>;
export declare const UpdateDeviceProvisioningRecipeFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    brand?: string | undefined;
    organizationUid?: string | undefined;
    model?: string | null | undefined;
    serialNumber?: string | null | undefined;
    tagUids?: string[] | null | undefined;
    macAddress?: string | null | undefined;
    deviceName?: string | null | undefined;
    policyUid?: string | null | undefined;
    locationUid?: string | null | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.ProvisioningRecipe.UpdateDeviceProvisioningRecipe";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    organizationUid?: string | undefined;
    serialNumber?: string | null | undefined;
    model?: string | null | undefined;
    macAddress?: string | null | undefined;
    brand?: string | undefined;
    tagUids?: string[] | null | undefined;
    deviceName?: string | null | undefined;
    policyUid?: string | null | undefined;
    locationUid?: string | null | undefined;
}, {}, Function>>) => z.TypeOf<import("../../Entity/entityCommands").UpdateEntityCommandSchema<"Device.ProvisioningRecipe.UpdateDeviceProvisioningRecipe", {
    uid: z.ZodString;
    organizationUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    serialNumber: z.ZodOptional<z.ZodString>;
    model: z.ZodOptional<z.ZodString>;
    macAddress: z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>>;
    brand: z.ZodString;
    tagUids: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodString]>, "many">>;
    deviceName: z.ZodOptional<z.ZodString>;
    policyUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
    locationUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
}>>;
export declare const DeleteDeviceProvisioningRecipe = "Device.ProvisioningRecipe.DeleteDeviceProvisioningRecipe";
export declare const DeleteDeviceProvisioningRecipeSchema: import("../../Entity/entityCommands").DeleteEntityCommandSchema<"Device.ProvisioningRecipe.DeleteDeviceProvisioningRecipe">;
export type DeleteDeviceProvisioningRecipe = z.infer<typeof DeleteDeviceProvisioningRecipeSchema>;
export declare const DeleteDeviceProvisioningRecipeFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.ProvisioningRecipe.DeleteDeviceProvisioningRecipe";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<import("../../Entity/entityCommands").DeleteEntityCommandSchema<"Device.ProvisioningRecipe.DeleteDeviceProvisioningRecipe">>;
export declare const ConfirmDeviceProvisioningRecipeOwnership = "Device.ProvisioningRecipe.ConfirmDeviceProvisioningRecipeOwnership";
export declare const ConfirmDeviceProvisioningRecipeOwnershipSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Device.ProvisioningRecipe.ConfirmDeviceProvisioningRecipeOwnership">;
    uid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.ProvisioningRecipe.ConfirmDeviceProvisioningRecipeOwnership";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.ProvisioningRecipe.ConfirmDeviceProvisioningRecipeOwnership";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type ConfirmDeviceProvisioningRecipeOwnership = z.infer<typeof ConfirmDeviceProvisioningRecipeOwnershipSchema>;
export declare const ConfirmDeviceProvisioningRecipeOwnershipFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.ProvisioningRecipe.ConfirmDeviceProvisioningRecipeOwnership";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Device.ProvisioningRecipe.ConfirmDeviceProvisioningRecipeOwnership">;
    uid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.ProvisioningRecipe.ConfirmDeviceProvisioningRecipeOwnership";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.ProvisioningRecipe.ConfirmDeviceProvisioningRecipeOwnership";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
