"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeviceProvisioningRecipeSchema = void 0;
const entityCommands_1 = require("../../Entity/entityCommands");
const zod_1 = require("zod");
const schemas_1 = require("../../schemas");
const locationCommands_1 = require("../../Location/locationCommands");
const organizationCommands_1 = require("../../Organization/organizationCommands");
exports.DeviceProvisioningRecipeSchema = entityCommands_1.EntitySchema.extend({
    organizationUid: organizationCommands_1.OrganizationUIDSchema,
    serialNumber: zod_1.z.string().max(256).optional(),
    model: zod_1.z.string().max(256).optional(),
    macAddress: schemas_1.MacAddressSchema.optional(),
    brand: zod_1.z.string().max(256),
    tagUids: zod_1.z.array(schemas_1.UIDSchema.or(schemas_1.LegacyUIDSchema)).optional(),
    deviceName: zod_1.z.string().max(256).optional(),
    policyUid: schemas_1.UIDSchema.or(schemas_1.LegacyUIDSchema).optional(),
    locationUid: locationCommands_1.LocationUidSchema.optional(),
});
//# sourceMappingURL=deviceProvisioningRecipe.js.map