import { z } from 'zod';
export declare const DeviceProvisioningRecipeSchema: z.ZodObject<{
    uid: z.ZodString;
    organizationUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    serialNumber: z.ZodOptional<z.ZodString>;
    model: z.ZodOptional<z.ZodString>;
    macAddress: z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>>;
    brand: z.ZodString;
    tagUids: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodString]>, "many">>;
    deviceName: z.ZodOptional<z.ZodString>;
    policyUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
    locationUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
}, "strict", z.ZodTypeAny, {
    brand: string;
    organizationUid: string;
    uid: string;
    serialNumber?: string | undefined;
    model?: string | undefined;
    macAddress?: string | undefined;
    tagUids?: string[] | undefined;
    deviceName?: string | undefined;
    policyUid?: string | undefined;
    locationUid?: string | undefined;
}, {
    brand: string;
    organizationUid: string;
    uid: string;
    serialNumber?: string | undefined;
    model?: string | undefined;
    macAddress?: string | undefined;
    tagUids?: string[] | undefined;
    deviceName?: string | undefined;
    policyUid?: string | undefined;
    locationUid?: string | undefined;
}>;
