"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CancelScheduledPowerActionFailedFactory = exports.CancelScheduledPowerActionFailedSchema = exports.CancelScheduledPowerActionFailed = exports.CancelScheduledPowerActionSucceedFactory = exports.CancelScheduledPowerActionSucceedSchema = exports.CancelScheduledPowerActionSucceed = exports.CancelScheduledPowerActionFactory = exports.CancelScheduledPowerActionSchema = exports.CancelScheduledPowerAction = exports.SchedulePowerActionFailedFactory = exports.SchedulePowerActionFailedSchema = exports.SchedulePowerActionFailed = exports.SchedulePowerActionSucceedFactory = exports.SchedulePowerActionSucceedSchema = exports.SchedulePowerActionSucceed = exports.SchedulePowerActionFactory = exports.SchedulePowerActionSchema = exports.SchedulePowerAction = exports.PerformPowerActionFailedFactory = exports.PerformPowerActionFailedSchema = exports.PerformPowerActionFailed = exports.PerformPowerActionSucceedFactory = exports.PerformPowerActionSucceedSchema = exports.PerformPowerActionSucceed = exports.PerformPowerActionFactory = exports.PerformPowerActionSchema = exports.PerformPowerAction = void 0;
const commandFactory_1 = require("../../commandFactory");
const zod_1 = require("zod");
const ICommand_1 = require("../../ICommand");
const Weekday_1 = require("../../Misc/Weekday");
const PowerActionType_1 = require("./PowerActionType");
const deviceCommands_1 = require("../deviceCommands");
const schemas_1 = require("../../schemas");
/**
 * The UID that is used to identify the power action.
 */
const PowerActionUid = zod_1.z.string();
exports.PerformPowerAction = 'Device.Power.PerformPowerAction';
exports.PerformPowerActionSchema = deviceCommands_1.SetDevicePropertySchema.extend({
    type: zod_1.z.literal(exports.PerformPowerAction),
    /** For backwards compatibility it has to be named id instead of uid. It's optional */
    id: PowerActionUid.optional(),
    powerType: PowerActionType_1.PowerActionTypeSchema,
});
exports.PerformPowerActionFactory = (0, commandFactory_1.createCommandFactory)(exports.PerformPowerActionSchema);
exports.PerformPowerActionSucceed = 'Device.Power.PerformPowerActionSucceed';
exports.PerformPowerActionSucceedSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.PerformPowerActionSucceed),
    /** For backwards compatibility it has to be named id instead of uid */
    id: PowerActionUid,
    deviceUid: deviceCommands_1.DeviceUidSchema,
});
exports.PerformPowerActionSucceedFactory = (0, commandFactory_1.createCommandFactory)(exports.PerformPowerActionSucceedSchema);
exports.PerformPowerActionFailed = 'Device.Power.PerformPowerActionFailed';
exports.PerformPowerActionFailedSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.PerformPowerActionFailed),
    /** For backwards compatibility it has to be named id instead of uid */
    id: PowerActionUid,
    deviceUid: deviceCommands_1.DeviceUidSchema,
});
exports.PerformPowerActionFailedFactory = (0, commandFactory_1.createCommandFactory)(exports.PerformPowerActionFailedSchema);
/**
 * The UID that is used to identify the scheduled power action.
 * It can be used to cancel the scheduled power action.
 */
const ScheduledPowerActionUid = zod_1.z.string();
exports.SchedulePowerAction = 'Device.Power.SchedulePowerAction';
exports.SchedulePowerActionSchema = deviceCommands_1.SetDevicePropertySchema.extend({
    type: zod_1.z.literal(exports.SchedulePowerAction),
    powerType: PowerActionType_1.PowerActionTypeSchema,
    weekdays: zod_1.z.array(Weekday_1.WeekdaySchema),
    time: schemas_1.TimeSchema,
});
exports.SchedulePowerActionFactory = (0, commandFactory_1.createCommandFactory)(exports.SchedulePowerActionSchema);
exports.SchedulePowerActionSucceed = 'Device.Power.SchedulePowerActionSucceed';
exports.SchedulePowerActionSucceedSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.SchedulePowerActionSucceed),
    uid: ScheduledPowerActionUid,
});
exports.SchedulePowerActionSucceedFactory = (0, commandFactory_1.createCommandFactory)(exports.SchedulePowerActionSucceedSchema);
exports.SchedulePowerActionFailed = 'Device.Power.SchedulePowerActionFailed';
exports.SchedulePowerActionFailedSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.SchedulePowerActionFailed),
    uid: ScheduledPowerActionUid,
});
exports.SchedulePowerActionFailedFactory = (0, commandFactory_1.createCommandFactory)(exports.SchedulePowerActionFailedSchema);
exports.CancelScheduledPowerAction = 'Device.Power.CancelScheduledPowerAction';
exports.CancelScheduledPowerActionSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.CancelScheduledPowerAction),
    /**
     * For backwards compatibility it has to be optional.
     * In that case, the device from the scheduled power action request by scheduledPowerActionUid is used
     */
    deviceIdentityHash: deviceCommands_1.DeviceIdentityHashSchema.optional(),
    scheduledPowerActionUid: ScheduledPowerActionUid,
});
exports.CancelScheduledPowerActionFactory = (0, commandFactory_1.createCommandFactory)(exports.CancelScheduledPowerActionSchema);
exports.CancelScheduledPowerActionSucceed = 'Device.Power.CancelScheduledPowerActionSucceed';
exports.CancelScheduledPowerActionSucceedSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.CancelScheduledPowerActionSucceed),
    uid: ScheduledPowerActionUid,
});
exports.CancelScheduledPowerActionSucceedFactory = (0, commandFactory_1.createCommandFactory)(exports.CancelScheduledPowerActionSucceedSchema);
exports.CancelScheduledPowerActionFailed = 'Device.Power.CancelScheduledPowerActionFailed';
exports.CancelScheduledPowerActionFailedSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.CancelScheduledPowerActionFailed),
    uid: ScheduledPowerActionUid,
});
exports.CancelScheduledPowerActionFailedFactory = (0, commandFactory_1.createCommandFactory)(exports.CancelScheduledPowerActionFailedSchema);
//# sourceMappingURL=devicePowerActionCommands.js.map