import { z } from 'zod';
export declare const PerformPowerAction = "Device.Power.PerformPowerAction";
export declare const PerformPowerActionSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.Power.PerformPowerAction">;
    id: z.ZodOptional<z.ZodString>;
    powerType: z.ZodNativeEnum<typeof import("./PowerActionType").default>;
}, "strict", z.ZodTypeAny, {
    type: "Device.Power.PerformPowerAction";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    powerType: import("./PowerActionType").default;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    id?: string | undefined;
}, {
    type: "Device.Power.PerformPowerAction";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    powerType: import("./PowerActionType").default;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    id?: string | undefined;
}>;
export type PerformPowerAction = z.infer<typeof PerformPowerActionSchema>;
export declare const PerformPowerActionFactory: (data: {
    id?: string | undefined;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    powerType: import("./PowerActionType").default;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Power.PerformPowerAction";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    powerType: import("./PowerActionType").default;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    id?: string | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.Power.PerformPowerAction">;
    id: z.ZodOptional<z.ZodString>;
    powerType: z.ZodNativeEnum<typeof import("./PowerActionType").default>;
}, "strict", z.ZodTypeAny, {
    type: "Device.Power.PerformPowerAction";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    powerType: import("./PowerActionType").default;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    id?: string | undefined;
}, {
    type: "Device.Power.PerformPowerAction";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    powerType: import("./PowerActionType").default;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    id?: string | undefined;
}>>;
export declare const PerformPowerActionSucceed = "Device.Power.PerformPowerActionSucceed";
export declare const PerformPowerActionSucceedSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.Power.PerformPowerActionSucceed">;
    id: z.ZodString;
    deviceUid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.Power.PerformPowerActionSucceed";
    id: string;
    deviceUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Power.PerformPowerActionSucceed";
    id: string;
    deviceUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type PerformPowerActionSucceed = z.infer<typeof PerformPowerActionSucceedSchema>;
export declare const PerformPowerActionSucceedFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    id: string;
    deviceUid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Power.PerformPowerActionSucceed";
    id: string;
    deviceUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.Power.PerformPowerActionSucceed">;
    id: z.ZodString;
    deviceUid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.Power.PerformPowerActionSucceed";
    id: string;
    deviceUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Power.PerformPowerActionSucceed";
    id: string;
    deviceUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const PerformPowerActionFailed = "Device.Power.PerformPowerActionFailed";
export declare const PerformPowerActionFailedSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.Power.PerformPowerActionFailed">;
    id: z.ZodString;
    deviceUid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.Power.PerformPowerActionFailed";
    id: string;
    deviceUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Power.PerformPowerActionFailed";
    id: string;
    deviceUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type PerformPowerActionFailed = z.infer<typeof PerformPowerActionFailedSchema>;
export declare const PerformPowerActionFailedFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    id: string;
    deviceUid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Power.PerformPowerActionFailed";
    id: string;
    deviceUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.Power.PerformPowerActionFailed">;
    id: z.ZodString;
    deviceUid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.Power.PerformPowerActionFailed";
    id: string;
    deviceUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Power.PerformPowerActionFailed";
    id: string;
    deviceUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const SchedulePowerAction = "Device.Power.SchedulePowerAction";
export declare const SchedulePowerActionSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.Power.SchedulePowerAction">;
    powerType: z.ZodNativeEnum<typeof import("./PowerActionType").default>;
    weekdays: z.ZodArray<z.ZodNativeEnum<typeof import("../../Misc/Weekday").default>, "many">;
    time: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.Power.SchedulePowerAction";
    time: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    weekdays: import("../../Misc/Weekday").default[];
    powerType: import("./PowerActionType").default;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Power.SchedulePowerAction";
    time: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    weekdays: import("../../Misc/Weekday").default[];
    powerType: import("./PowerActionType").default;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type SchedulePowerAction = z.infer<typeof SchedulePowerActionSchema>;
export declare const SchedulePowerActionFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    time: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    weekdays: import("../../Misc/Weekday").default[];
    powerType: import("./PowerActionType").default;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Power.SchedulePowerAction";
    time: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    weekdays: import("../../Misc/Weekday").default[];
    powerType: import("./PowerActionType").default;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.Power.SchedulePowerAction">;
    powerType: z.ZodNativeEnum<typeof import("./PowerActionType").default>;
    weekdays: z.ZodArray<z.ZodNativeEnum<typeof import("../../Misc/Weekday").default>, "many">;
    time: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.Power.SchedulePowerAction";
    time: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    weekdays: import("../../Misc/Weekday").default[];
    powerType: import("./PowerActionType").default;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Power.SchedulePowerAction";
    time: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    weekdays: import("../../Misc/Weekday").default[];
    powerType: import("./PowerActionType").default;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const SchedulePowerActionSucceed = "Device.Power.SchedulePowerActionSucceed";
export declare const SchedulePowerActionSucceedSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.Power.SchedulePowerActionSucceed">;
    uid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.Power.SchedulePowerActionSucceed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Power.SchedulePowerActionSucceed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type SchedulePowerActionSucceed = z.infer<typeof SchedulePowerActionSucceedSchema>;
export declare const SchedulePowerActionSucceedFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Power.SchedulePowerActionSucceed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.Power.SchedulePowerActionSucceed">;
    uid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.Power.SchedulePowerActionSucceed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Power.SchedulePowerActionSucceed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const SchedulePowerActionFailed = "Device.Power.SchedulePowerActionFailed";
export declare const SchedulePowerActionFailedSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.Power.SchedulePowerActionFailed">;
    uid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.Power.SchedulePowerActionFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Power.SchedulePowerActionFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type SchedulePowerActionFailed = z.infer<typeof SchedulePowerActionFailedSchema>;
export declare const SchedulePowerActionFailedFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Power.SchedulePowerActionFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.Power.SchedulePowerActionFailed">;
    uid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.Power.SchedulePowerActionFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Power.SchedulePowerActionFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const CancelScheduledPowerAction = "Device.Power.CancelScheduledPowerAction";
export declare const CancelScheduledPowerActionSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Device.Power.CancelScheduledPowerAction">;
    deviceIdentityHash: z.ZodOptional<z.ZodString>;
    scheduledPowerActionUid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.Power.CancelScheduledPowerAction";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    scheduledPowerActionUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    deviceIdentityHash?: string | undefined;
}, {
    type: "Device.Power.CancelScheduledPowerAction";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    scheduledPowerActionUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    deviceIdentityHash?: string | undefined;
}>;
export type CancelScheduledPowerAction = z.infer<typeof CancelScheduledPowerActionSchema>;
export declare const CancelScheduledPowerActionFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    deviceIdentityHash?: string | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    scheduledPowerActionUid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Power.CancelScheduledPowerAction";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    scheduledPowerActionUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    deviceIdentityHash?: string | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Device.Power.CancelScheduledPowerAction">;
    deviceIdentityHash: z.ZodOptional<z.ZodString>;
    scheduledPowerActionUid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.Power.CancelScheduledPowerAction";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    scheduledPowerActionUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    deviceIdentityHash?: string | undefined;
}, {
    type: "Device.Power.CancelScheduledPowerAction";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    scheduledPowerActionUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    deviceIdentityHash?: string | undefined;
}>>;
export declare const CancelScheduledPowerActionSucceed = "Device.Power.CancelScheduledPowerActionSucceed";
export declare const CancelScheduledPowerActionSucceedSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.Power.CancelScheduledPowerActionSucceed">;
    uid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.Power.CancelScheduledPowerActionSucceed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Power.CancelScheduledPowerActionSucceed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type CancelScheduledPowerActionSucceed = z.infer<typeof CancelScheduledPowerActionSucceedSchema>;
export declare const CancelScheduledPowerActionSucceedFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Power.CancelScheduledPowerActionSucceed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.Power.CancelScheduledPowerActionSucceed">;
    uid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.Power.CancelScheduledPowerActionSucceed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Power.CancelScheduledPowerActionSucceed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const CancelScheduledPowerActionFailed = "Device.Power.CancelScheduledPowerActionFailed";
export declare const CancelScheduledPowerActionFailedSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.Power.CancelScheduledPowerActionFailed">;
    uid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.Power.CancelScheduledPowerActionFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Power.CancelScheduledPowerActionFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type CancelScheduledPowerActionFailed = z.infer<typeof CancelScheduledPowerActionFailedSchema>;
export declare const CancelScheduledPowerActionFailedFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Power.CancelScheduledPowerActionFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.Power.CancelScheduledPowerActionFailed">;
    uid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.Power.CancelScheduledPowerActionFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Power.CancelScheduledPowerActionFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
