import { z } from 'zod';
export declare const SetPeerRecovery = "Device.PeerRecovery.SetPeerRecovery";
export declare const SetEnablePeerRecoverySchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.PeerRecovery.SetPeerRecovery">;
    enabled: z.ZodLiteral<true>;
    urlLauncherAddress: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.PeerRecovery.SetPeerRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: true;
    urlLauncherAddress: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.PeerRecovery.SetPeerRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: true;
    urlLauncherAddress: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export declare const SetDisablePeerRecoverySchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.PeerRecovery.SetPeerRecovery">;
    enabled: z.ZodLiteral<false>;
    autoEnableTimeoutMs: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    type: "Device.PeerRecovery.SetPeerRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: false;
    autoEnableTimeoutMs: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.PeerRecovery.SetPeerRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: false;
    autoEnableTimeoutMs: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export declare const SetPeerRecoverySchema: z.ZodDiscriminatedUnion<"enabled", [z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.PeerRecovery.SetPeerRecovery">;
    enabled: z.ZodLiteral<true>;
    urlLauncherAddress: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.PeerRecovery.SetPeerRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: true;
    urlLauncherAddress: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.PeerRecovery.SetPeerRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: true;
    urlLauncherAddress: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>, z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.PeerRecovery.SetPeerRecovery">;
    enabled: z.ZodLiteral<false>;
    autoEnableTimeoutMs: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    type: "Device.PeerRecovery.SetPeerRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: false;
    autoEnableTimeoutMs: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.PeerRecovery.SetPeerRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: false;
    autoEnableTimeoutMs: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>]>;
export type SetPeerRecovery = z.infer<typeof SetPeerRecoverySchema>;
export type SetEnablePeerRecovery = z.infer<typeof SetEnablePeerRecoverySchema>;
export type SetDisablePeerRecovery = z.infer<typeof SetDisablePeerRecoverySchema>;
export declare const SetPeerRecoveryFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: boolean;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.PeerRecovery.SetPeerRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: true;
    urlLauncherAddress: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} | {
    type: "Device.PeerRecovery.SetPeerRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: false;
    autoEnableTimeoutMs: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodDiscriminatedUnion<"enabled", [z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.PeerRecovery.SetPeerRecovery">;
    enabled: z.ZodLiteral<true>;
    urlLauncherAddress: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.PeerRecovery.SetPeerRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: true;
    urlLauncherAddress: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.PeerRecovery.SetPeerRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: true;
    urlLauncherAddress: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>, z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.PeerRecovery.SetPeerRecovery">;
    enabled: z.ZodLiteral<false>;
    autoEnableTimeoutMs: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    type: "Device.PeerRecovery.SetPeerRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: false;
    autoEnableTimeoutMs: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.PeerRecovery.SetPeerRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: false;
    autoEnableTimeoutMs: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>]>>;
export declare const SetEnablePeerRecoveryFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: import("../../types").ObjectRecursiveDifference<{
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, import("../../commandFactory").PropGenerator | {
        accountId?: import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        }> | (number | undefined);
        organizationUid?: import("../../commandFactory").PropGenerator | (string | undefined) | import("../../commandFactory").PropGeneratorWithPayload<{
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        }>;
    } | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.PeerRecovery.SetPeerRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: true;
        urlLauncherAddress: string;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }> | undefined, Function>;
    deviceIdentityHash: string;
    enabled: true;
    urlLauncherAddress: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.PeerRecovery.SetPeerRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: true;
    urlLauncherAddress: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type?: import("../../commandFactory").PropGenerator | "Device.PeerRecovery.SetPeerRecovery" | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.PeerRecovery.SetPeerRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: true;
        urlLauncherAddress: string;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }> | undefined;
    originator?: import("../../commandFactory").PropGenerator | {
        accountId?: import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        }> | (number | undefined);
        organizationUid?: import("../../commandFactory").PropGenerator | (string | undefined) | import("../../commandFactory").PropGeneratorWithPayload<{
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        }>;
    } | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.PeerRecovery.SetPeerRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: true;
        urlLauncherAddress: string;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }> | undefined;
    deviceIdentityHash?: string | import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.PeerRecovery.SetPeerRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: true;
        urlLauncherAddress: string;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }> | undefined;
    enabled?: true | import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.PeerRecovery.SetPeerRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: true;
        urlLauncherAddress: string;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }> | undefined;
    urlLauncherAddress?: string | import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.PeerRecovery.SetPeerRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: true;
        urlLauncherAddress: string;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }> | undefined;
    context?: import("../../commandFactory").PropGenerator | ({
        whiteLabelSettingsUid?: import("../../commandFactory").PropGenerator | (string | undefined) | import("../../commandFactory").PropGeneratorWithPayload<{
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        }>;
        auth0Enabled?: import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        }> | (boolean | undefined);
    } | undefined) | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.PeerRecovery.SetPeerRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: true;
        urlLauncherAddress: string;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }>;
}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.PeerRecovery.SetPeerRecovery">;
    enabled: z.ZodLiteral<true>;
    urlLauncherAddress: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.PeerRecovery.SetPeerRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: true;
    urlLauncherAddress: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.PeerRecovery.SetPeerRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: true;
    urlLauncherAddress: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const SetDisablePeerRecoveryFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: import("../../types").ObjectRecursiveDifference<{
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, import("../../commandFactory").PropGenerator | {
        accountId?: import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        }> | (number | undefined);
        organizationUid?: import("../../commandFactory").PropGenerator | (string | undefined) | import("../../commandFactory").PropGeneratorWithPayload<{
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        }>;
    } | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.PeerRecovery.SetPeerRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: false;
        autoEnableTimeoutMs: number;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }> | undefined, Function>;
    deviceIdentityHash: string;
    enabled: false;
    autoEnableTimeoutMs: number;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.PeerRecovery.SetPeerRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: false;
    autoEnableTimeoutMs: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type?: import("../../commandFactory").PropGenerator | "Device.PeerRecovery.SetPeerRecovery" | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.PeerRecovery.SetPeerRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: false;
        autoEnableTimeoutMs: number;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }> | undefined;
    originator?: import("../../commandFactory").PropGenerator | {
        accountId?: import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        }> | (number | undefined);
        organizationUid?: import("../../commandFactory").PropGenerator | (string | undefined) | import("../../commandFactory").PropGeneratorWithPayload<{
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        }>;
    } | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.PeerRecovery.SetPeerRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: false;
        autoEnableTimeoutMs: number;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }> | undefined;
    deviceIdentityHash?: string | import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.PeerRecovery.SetPeerRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: false;
        autoEnableTimeoutMs: number;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }> | undefined;
    enabled?: false | import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.PeerRecovery.SetPeerRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: false;
        autoEnableTimeoutMs: number;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }> | undefined;
    autoEnableTimeoutMs?: number | import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.PeerRecovery.SetPeerRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: false;
        autoEnableTimeoutMs: number;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }> | undefined;
    context?: import("../../commandFactory").PropGenerator | ({
        whiteLabelSettingsUid?: import("../../commandFactory").PropGenerator | (string | undefined) | import("../../commandFactory").PropGeneratorWithPayload<{
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        }>;
        auth0Enabled?: import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        }> | (boolean | undefined);
    } | undefined) | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.PeerRecovery.SetPeerRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: false;
        autoEnableTimeoutMs: number;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }>;
}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.PeerRecovery.SetPeerRecovery">;
    enabled: z.ZodLiteral<false>;
    autoEnableTimeoutMs: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    type: "Device.PeerRecovery.SetPeerRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: false;
    autoEnableTimeoutMs: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.PeerRecovery.SetPeerRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: false;
    autoEnableTimeoutMs: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const MarkSetPeerRecoverySucceeded = "Device.PeerRecovery.MarkSetPeerRecoverySucceeded";
export declare const MarkSetPeerRecoverySucceededSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.PeerRecovery.MarkSetPeerRecoverySucceeded">;
}, "strict", z.ZodTypeAny, {
    type: "Device.PeerRecovery.MarkSetPeerRecoverySucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.PeerRecovery.MarkSetPeerRecoverySucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type MarkSetPeerRecoverySucceeded = z.infer<typeof MarkSetPeerRecoverySucceededSchema>;
export declare const MarkSetPeerRecoverySucceededFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.PeerRecovery.MarkSetPeerRecoverySucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.PeerRecovery.MarkSetPeerRecoverySucceeded">;
}, "strict", z.ZodTypeAny, {
    type: "Device.PeerRecovery.MarkSetPeerRecoverySucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.PeerRecovery.MarkSetPeerRecoverySucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const MarkSetPeerRecoveryFailed = "Device.PeerRecovery.MarkSetPeerRecoveryFailed";
export declare const MarkSetPeerRecoveryFailedSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.PeerRecovery.MarkSetPeerRecoveryFailed">;
}, "strict", z.ZodTypeAny, {
    type: "Device.PeerRecovery.MarkSetPeerRecoveryFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.PeerRecovery.MarkSetPeerRecoveryFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type MarkSetPeerRecoveryFailed = z.infer<typeof MarkSetPeerRecoveryFailedSchema>;
export declare const MarkSetPeerRecoveryFailedFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.PeerRecovery.MarkSetPeerRecoveryFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.PeerRecovery.MarkSetPeerRecoveryFailed">;
}, "strict", z.ZodTypeAny, {
    type: "Device.PeerRecovery.MarkSetPeerRecoveryFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.PeerRecovery.MarkSetPeerRecoveryFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
