import ICommand from '../../ICommand';
import ApplicationType from '@signageos/common-types/dist/Application/ApplicationType';
import { IMarkSetDevicePropertyDone, ISetDeviceProperty } from '../deviceCommands';
export declare const NotifyDeviceFirmwareVersion = "Device.Firmware.NotifyDeviceFirmwareVersion";
export interface NotifyDeviceFirmwareVersion extends ICommand<typeof NotifyDeviceFirmwareVersion> {
    duid: string;
    version: string;
}
export declare const NotifyDeviceFirmwareType = "Device.Firmware.NotifyDeviceFirmwareType";
export interface NotifyDeviceFirmwareType extends ICommand<typeof NotifyDeviceFirmwareType> {
    duid: string;
    /**
     * It's optional and currently used only for linux & android
     * E.g.: rpi, rpi4, benq_sl550
     */
    firmwareType: string;
}
export declare const SetDeviceFirmwareVersion = "Device.Firmware.SetDeviceFirmwareVersion";
export interface SetDeviceFirmwareVersion extends ISetDeviceProperty<typeof SetDeviceFirmwareVersion> {
    applicationType: ApplicationType;
    version: string;
}
export declare const UpdateSetDeviceFirmwareVersionProgress = "Device.Firmware.UpdateSetDeviceFirmwareVersionProgress";
export interface UpdateSetDeviceFirmwareVersionProgress extends ICommand<typeof UpdateSetDeviceFirmwareVersionProgress> {
    uid: string;
    progress: number;
}
export declare const MarkSetDeviceFirmwareVersionSucceeded = "Device.Firmware.MarkSetDeviceFirmwareVersionSucceeded";
export type MarkSetDeviceFirmwareVersionSucceeded = IMarkSetDevicePropertyDone<typeof MarkSetDeviceFirmwareVersionSucceeded>;
export declare const MarkSetDeviceFirmwareVersionFailed = "Device.Firmware.MarkSetDeviceFirmwareVersionFailed";
export type MarkSetDeviceFirmwareVersionFailed = IMarkSetDevicePropertyDone<typeof MarkSetDeviceFirmwareVersionFailed>;
