import IBaseCommand, { IOriginatorAwareCommand } from '../../ICommand';
export type StartLogExportType = 'Device.Export.StartLogExport';
export declare const StartLogExport: StartLogExportType;
export interface StartLogExport extends IOriginatorAwareCommand<StartLogExportType> {
    requestId: string;
    startDate: Date;
    endDate: Date;
}
export type MarkLogExportSucceededType = 'Device.Export.MarkLogExportSucceeded';
export declare const MarkLogExportSucceeded: MarkLogExportSucceededType;
export interface MarkLogExportSucceeded extends IBaseCommand<MarkLogExportSucceededType> {
    requestId: string;
    downloadLink: string;
}
export type MarkLogExportFailedType = 'Device.Export.MarkLogExportFailed';
export declare const MarkLogExportFailed: MarkLogExportFailedType;
export interface MarkLogExportFailed extends IBaseCommand<MarkLogExportFailedType> {
    requestId: string;
    errorDescription: string;
}
