import BaseCommand from '../../ICommand';
import { ISetDeviceProperty } from '../deviceCommands';
import { SocketDriver } from '@signageos/common-types/dist/Device/Settings/DeviceSettings';
export declare const UpdateDeviceConfiguration = "Device.Configuration.UpdateDeviceConfiguration";
/**
 * Update configuration of device.
 * Device is downloading configuration from URL https://platform.signageos.io/configuration/{{duid}} which is hardcoded in core apps.
 * Omitted values are kept as before. No changes are applied to ? values.
 * Null values will update configuration to device core app default or server default.
 * The device always has some default values hardcoded in device core app build.
 * This configuration is usually used for debug or for on-premise instances of platform.
 */
export interface UpdateDeviceConfiguration extends ISetDeviceProperty<typeof UpdateDeviceConfiguration> {
    /** Server url where device is primarily pointing to the socket communication */
    platformUri?: string | null;
    /** Server url where device static files are primarily downloaded from */
    staticBaseUrl?: string | null;
    /** Server url where device screenshots are primarily uploaded to */
    uploadBaseUrl?: string | null;
    /** Server url where debug weinre server is device connecting to */
    weinreUri?: string | null;
    /**
     * Platform specific remote control server url.
     * For example, the samsung uses MagicInfo URL to connect to remote control server.
     */
    extendedManagementUrl?: string | null;
    /**
     * The strategy which is device using for socket communication.
     * The currently suggested driver is "ws" which is default set on new device core apps.
     * New failover driver is "http" which is used for REST API light-weight communication with device.
     * Usually delayed first response by 1 minute.
     * Deprecated driver is "socketio" which is default set to obsolete device code apps.
     */
    socketDriver?: SocketDriver | null;
}
export declare const ReportDeviceConfigurationProtocol = "Device.Configuration.ReportDeviceConfigurationProtocol";
/**
 * Report which protocol the device used during its last configuration request
 */
export interface ReportDeviceConfigurationProtocol extends BaseCommand<typeof ReportDeviceConfigurationProtocol> {
    deviceUid: string;
    protocol: 'http' | 'https';
}
