"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MarkSetAutoRecoveryFailedFactory = exports.MarkSetAutoRecoveryFailedSchema = exports.MarkSetAutoRecoveryFailed = exports.MarkSetAutoRecoverySucceededFactory = exports.MarkSetAutoRecoverySucceededSchema = exports.MarkSetAutoRecoverySucceeded = exports.SetDisableAutoRecoveryFactory = exports.SetEnableAutoRecoveryFactory = exports.SetAutoRecoveryFactory = exports.SetAutoRecoverySchema = exports.SetDisableAutoRecoverySchema = exports.SetEnableAutoRecoverySchema = exports.SetAutoRecovery = void 0;
const zod_1 = require("zod");
const commandFactory_1 = require("../../commandFactory");
const deviceCommands_1 = require("../deviceCommands");
exports.SetAutoRecovery = 'Device.AutoRecovery.SetAutoRecovery';
exports.SetEnableAutoRecoverySchema = deviceCommands_1.SetDevicePropertySchema.extend({
    type: zod_1.z.literal(exports.SetAutoRecovery),
    enabled: zod_1.z.literal(true),
    /**
     * It defines in milliseconds period whose elapsing leads to mark browser process as unresponding.
     */
    healthcheckIntervalMs: zod_1.z.number().positive(),
}).strict();
exports.SetDisableAutoRecoverySchema = deviceCommands_1.SetDevicePropertySchema.extend({
    type: zod_1.z.literal(exports.SetAutoRecovery),
    enabled: zod_1.z.literal(false),
    /**
     * It defines period until automatic enabling auto recovery process in milliseconds.
     */
    autoEnableTimeoutMs: zod_1.z.number().positive().optional(),
}).strict();
exports.SetAutoRecoverySchema = zod_1.z.discriminatedUnion('enabled', [exports.SetEnableAutoRecoverySchema, exports.SetDisableAutoRecoverySchema]);
exports.SetAutoRecoveryFactory = (0, commandFactory_1.createCommandFactory)(exports.SetAutoRecoverySchema);
exports.SetEnableAutoRecoveryFactory = (0, commandFactory_1.createCommandFactory)(exports.SetEnableAutoRecoverySchema, undefined, { noRegisterCommandSchema: true });
exports.SetDisableAutoRecoveryFactory = (0, commandFactory_1.createCommandFactory)(exports.SetDisableAutoRecoverySchema, undefined, {
    noRegisterCommandSchema: true,
});
exports.MarkSetAutoRecoverySucceeded = 'Device.AutoRecovery.MarkAutoRecoverySucceeded';
exports.MarkSetAutoRecoverySucceededSchema = deviceCommands_1.MarkSetDevicePropertyDoneSchema.extend({
    type: zod_1.z.literal(exports.MarkSetAutoRecoverySucceeded),
}).strict();
exports.MarkSetAutoRecoverySucceededFactory = (0, commandFactory_1.createCommandFactory)(exports.MarkSetAutoRecoverySucceededSchema);
exports.MarkSetAutoRecoveryFailed = 'Device.AutoRecovery.MarkAutoRecoveryFailed';
exports.MarkSetAutoRecoveryFailedSchema = deviceCommands_1.MarkSetDevicePropertyDoneSchema.extend({
    type: zod_1.z.literal(exports.MarkSetAutoRecoveryFailed),
}).strict();
exports.MarkSetAutoRecoveryFailedFactory = (0, commandFactory_1.createCommandFactory)(exports.MarkSetAutoRecoveryFailedSchema);
//# sourceMappingURL=deviceAutoRecoveryCommands.js.map