"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateApplicationVersionDescription = exports.RenewApplicationVersion = exports.DeprecateApplicationVersion = exports.UnpublishApplicationVersion = exports.PublishApplicationVersion = exports.CreateApplicationVersionFactory = exports.CreateApplicationVersionSchema = exports.CreateApplicationVersion = void 0;
const zod_1 = require("zod");
const commandFactory_1 = require("../../commandFactory");
const ICommand_1 = require("../../ICommand");
const ApplicationType_1 = require("@signageos/common-types/dist/Application/ApplicationType");
exports.CreateApplicationVersion = 'Application.Version.CreateApplicationVersion';
exports.CreateApplicationVersionSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.CreateApplicationVersion),
    applicationType: ApplicationType_1.ApplicationTypeSchema,
    frontDisplayVersion: zod_1.z.string(),
    version: zod_1.z.string(),
    supportedFirmwareTypes: zod_1.z.string().array().optional(),
}).strict();
exports.CreateApplicationVersionFactory = (0, commandFactory_1.createCommandFactory)(exports.CreateApplicationVersionSchema);
exports.PublishApplicationVersion = 'Application.Version.PublishApplicationVersion';
exports.UnpublishApplicationVersion = 'Application.Version.UnpublishApplicationVersion';
exports.DeprecateApplicationVersion = 'Application.Version.DeprecateApplicationVersion';
exports.RenewApplicationVersion = 'Application.Version.RenewApplicationVersion';
exports.UpdateApplicationVersionDescription = 'Application.Version.UpdateApplicationVersionDescription';
//# sourceMappingURL=applicationVersionCommands.js.map