import { z } from 'zod';
import { SubscriptionType } from '@signageos/common-types/dist/Subscription/subscription';
export declare const ApplicationVersionBuildRequestUidSchema: z.ZodString;
export declare const AppletConfigSchema: z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
export type AppletConfig = z.infer<typeof AppletConfigSchema>;
export declare const BuildApplicationVersion = "Application.Version.BuildApplicationVersion";
export declare const BuildApplicationVersionSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Application.Version.BuildApplicationVersion">;
    requestUid: z.ZodDefault<z.ZodString>;
    applicationType: z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>;
    applicationVersion: z.ZodString;
    applicationSignature: z.ZodOptional<z.ZodString>;
    applicationFlavour: z.ZodOptional<z.ZodString>;
    bundledAppletUid: z.ZodString;
    bundledAppletName: z.ZodString;
    bundledAppletVersion: z.ZodString;
    bundledAppletUpdatedAt: z.ZodDate;
    bundledAppletPublishedSince: z.ZodOptional<z.ZodNullable<z.ZodDate>>;
    bundledAppletEntryFile: z.ZodString;
    bundledAppletBaseUrl: z.ZodString;
    bundledAppletFiles: z.ZodArray<z.ZodString, "many">;
    bundledAppletConfig: z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>>;
    bundledFrontAppletVersion: z.ZodNullable<z.ZodString>;
    bundledFrontAppletBinaryFileUrl: z.ZodNullable<z.ZodString>;
    organizationUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    organizationName: z.ZodString;
    subscriptionType: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<SubscriptionType.Platform>, z.ZodLiteral<SubscriptionType.Open>]>>;
}, "strict", z.ZodTypeAny, {
    type: "Application.Version.BuildApplicationVersion";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos";
    requestUid: string;
    applicationVersion: string;
    bundledAppletUid: string;
    bundledAppletName: string;
    bundledAppletVersion: string;
    bundledAppletUpdatedAt: Date;
    bundledAppletEntryFile: string;
    bundledAppletBaseUrl: string;
    bundledAppletFiles: string[];
    bundledAppletConfig: Record<string, string | string[]> | null;
    bundledFrontAppletVersion: string | null;
    bundledFrontAppletBinaryFileUrl: string | null;
    organizationName: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    applicationSignature?: string | undefined;
    applicationFlavour?: string | undefined;
    bundledAppletPublishedSince?: Date | null | undefined;
    subscriptionType?: SubscriptionType.Open | SubscriptionType.Platform | undefined;
}, {
    type: "Application.Version.BuildApplicationVersion";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos";
    applicationVersion: string;
    bundledAppletUid: string;
    bundledAppletName: string;
    bundledAppletVersion: string;
    bundledAppletUpdatedAt: Date;
    bundledAppletEntryFile: string;
    bundledAppletBaseUrl: string;
    bundledAppletFiles: string[];
    bundledAppletConfig: Record<string, string | string[]> | null;
    bundledFrontAppletVersion: string | null;
    bundledFrontAppletBinaryFileUrl: string | null;
    organizationName: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    requestUid?: string | undefined;
    applicationSignature?: string | undefined;
    applicationFlavour?: string | undefined;
    bundledAppletPublishedSince?: Date | null | undefined;
    subscriptionType?: SubscriptionType.Open | SubscriptionType.Platform | undefined;
}>;
export type BuildApplicationVersion = z.infer<typeof BuildApplicationVersionSchema>;
export declare const BuildApplicationVersionFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    subscriptionType?: SubscriptionType.Open | SubscriptionType.Platform | undefined;
    applicationSignature?: string | undefined;
    applicationFlavour?: string | undefined;
    bundledAppletPublishedSince?: Date | null | undefined;
} & {
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos";
    applicationVersion: string;
    bundledAppletUid: string;
    bundledAppletName: string;
    bundledAppletVersion: string;
    bundledAppletUpdatedAt: Date;
    bundledAppletEntryFile: string;
    bundledAppletBaseUrl: string;
    bundledAppletFiles: string[];
    bundledAppletConfig: Record<string, string | string[]> | null;
    bundledFrontAppletVersion: string | null;
    bundledFrontAppletBinaryFileUrl: string | null;
    organizationName: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Application.Version.BuildApplicationVersion";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos";
    requestUid: string;
    applicationVersion: string;
    bundledAppletUid: string;
    bundledAppletName: string;
    bundledAppletVersion: string;
    bundledAppletUpdatedAt: Date;
    bundledAppletEntryFile: string;
    bundledAppletBaseUrl: string;
    bundledAppletFiles: string[];
    bundledAppletConfig: Record<string, string | string[]> | null;
    bundledFrontAppletVersion: string | null;
    bundledFrontAppletBinaryFileUrl: string | null;
    organizationName: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    applicationSignature?: string | undefined;
    applicationFlavour?: string | undefined;
    bundledAppletPublishedSince?: Date | null | undefined;
    subscriptionType?: SubscriptionType.Open | SubscriptionType.Platform | undefined;
}, {
    requestUid: () => string;
}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Application.Version.BuildApplicationVersion">;
    requestUid: z.ZodDefault<z.ZodString>;
    applicationType: z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>;
    applicationVersion: z.ZodString;
    applicationSignature: z.ZodOptional<z.ZodString>;
    applicationFlavour: z.ZodOptional<z.ZodString>;
    bundledAppletUid: z.ZodString;
    bundledAppletName: z.ZodString;
    bundledAppletVersion: z.ZodString;
    bundledAppletUpdatedAt: z.ZodDate;
    bundledAppletPublishedSince: z.ZodOptional<z.ZodNullable<z.ZodDate>>;
    bundledAppletEntryFile: z.ZodString;
    bundledAppletBaseUrl: z.ZodString;
    bundledAppletFiles: z.ZodArray<z.ZodString, "many">;
    bundledAppletConfig: z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>>;
    bundledFrontAppletVersion: z.ZodNullable<z.ZodString>;
    bundledFrontAppletBinaryFileUrl: z.ZodNullable<z.ZodString>;
    organizationUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    organizationName: z.ZodString;
    subscriptionType: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<SubscriptionType.Platform>, z.ZodLiteral<SubscriptionType.Open>]>>;
}, "strict", z.ZodTypeAny, {
    type: "Application.Version.BuildApplicationVersion";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos";
    requestUid: string;
    applicationVersion: string;
    bundledAppletUid: string;
    bundledAppletName: string;
    bundledAppletVersion: string;
    bundledAppletUpdatedAt: Date;
    bundledAppletEntryFile: string;
    bundledAppletBaseUrl: string;
    bundledAppletFiles: string[];
    bundledAppletConfig: Record<string, string | string[]> | null;
    bundledFrontAppletVersion: string | null;
    bundledFrontAppletBinaryFileUrl: string | null;
    organizationName: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    applicationSignature?: string | undefined;
    applicationFlavour?: string | undefined;
    bundledAppletPublishedSince?: Date | null | undefined;
    subscriptionType?: SubscriptionType.Open | SubscriptionType.Platform | undefined;
}, {
    type: "Application.Version.BuildApplicationVersion";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos";
    applicationVersion: string;
    bundledAppletUid: string;
    bundledAppletName: string;
    bundledAppletVersion: string;
    bundledAppletUpdatedAt: Date;
    bundledAppletEntryFile: string;
    bundledAppletBaseUrl: string;
    bundledAppletFiles: string[];
    bundledAppletConfig: Record<string, string | string[]> | null;
    bundledFrontAppletVersion: string | null;
    bundledFrontAppletBinaryFileUrl: string | null;
    organizationName: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    requestUid?: string | undefined;
    applicationSignature?: string | undefined;
    applicationFlavour?: string | undefined;
    bundledAppletPublishedSince?: Date | null | undefined;
    subscriptionType?: SubscriptionType.Open | SubscriptionType.Platform | undefined;
}>>;
export declare const NotifyApplicationVersionBuildSucceeded = "Application.Version.NotifyApplicationVersionBuildSucceeded";
export declare const NotifyApplicationVersionBuildSucceededSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Application.Version.NotifyApplicationVersionBuildSucceeded">;
    requestUid: z.ZodString;
    archiveUrl: z.ZodString;
    directUrl: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Application.Version.NotifyApplicationVersionBuildSucceeded";
    requestUid: string;
    archiveUrl: string;
    directUrl: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Application.Version.NotifyApplicationVersionBuildSucceeded";
    requestUid: string;
    archiveUrl: string;
    directUrl: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type NotifyApplicationVersionBuildSucceeded = z.infer<typeof NotifyApplicationVersionBuildSucceededSchema>;
export declare const NotifyApplicationVersionBuildSucceededFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    requestUid: string;
    archiveUrl: string;
    directUrl: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Application.Version.NotifyApplicationVersionBuildSucceeded";
    requestUid: string;
    archiveUrl: string;
    directUrl: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Application.Version.NotifyApplicationVersionBuildSucceeded">;
    requestUid: z.ZodString;
    archiveUrl: z.ZodString;
    directUrl: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Application.Version.NotifyApplicationVersionBuildSucceeded";
    requestUid: string;
    archiveUrl: string;
    directUrl: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Application.Version.NotifyApplicationVersionBuildSucceeded";
    requestUid: string;
    archiveUrl: string;
    directUrl: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const NotifyApplicationVersionBuildFailed = "Application.Version.NotifyApplicationVersionBuildFailed";
export declare const NotifyApplicationVersionBuildFailedSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Application.Version.NotifyApplicationVersionBuildFailed">;
    requestUid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Application.Version.NotifyApplicationVersionBuildFailed";
    requestUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Application.Version.NotifyApplicationVersionBuildFailed";
    requestUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type NotifyApplicationVersionBuildFailed = z.infer<typeof NotifyApplicationVersionBuildFailedSchema>;
export declare const NotifyApplicationVersionBuildFailedFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    requestUid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Application.Version.NotifyApplicationVersionBuildFailed";
    requestUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Application.Version.NotifyApplicationVersionBuildFailed">;
    requestUid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Application.Version.NotifyApplicationVersionBuildFailed";
    requestUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Application.Version.NotifyApplicationVersionBuildFailed";
    requestUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
