import { z } from 'zod';
export declare const CreateAppletVersion = "Applet.Version.CreateAppletVersion";
export declare const CreateAppletVersionSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Applet.Version.CreateAppletVersion">;
    appletUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    version: z.ZodString;
    binary: z.ZodNullable<z.ZodString>;
    frontAppletVersion: z.ZodNullable<z.ZodString>;
    bundledFrontApplet: z.ZodOptional<z.ZodBoolean>;
    entryFile: z.ZodNullable<z.ZodOptional<z.ZodString>>;
}, "strict", z.ZodTypeAny, {
    type: "Applet.Version.CreateAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    binary: string | null;
    frontAppletVersion: string | null;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    bundledFrontApplet?: boolean | undefined;
    entryFile?: string | null | undefined;
}, {
    type: "Applet.Version.CreateAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    binary: string | null;
    frontAppletVersion: string | null;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    bundledFrontApplet?: boolean | undefined;
    entryFile?: string | null | undefined;
}>;
export type CreateAppletVersion = z.infer<typeof CreateAppletVersionSchema>;
export declare const CreateAppletVersionFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    bundledFrontApplet?: boolean | undefined;
    entryFile?: string | null | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    binary: string | null;
    frontAppletVersion: string | null;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Applet.Version.CreateAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    binary: string | null;
    frontAppletVersion: string | null;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    bundledFrontApplet?: boolean | undefined;
    entryFile?: string | null | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Applet.Version.CreateAppletVersion">;
    appletUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    version: z.ZodString;
    binary: z.ZodNullable<z.ZodString>;
    frontAppletVersion: z.ZodNullable<z.ZodString>;
    bundledFrontApplet: z.ZodOptional<z.ZodBoolean>;
    entryFile: z.ZodNullable<z.ZodOptional<z.ZodString>>;
}, "strict", z.ZodTypeAny, {
    type: "Applet.Version.CreateAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    binary: string | null;
    frontAppletVersion: string | null;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    bundledFrontApplet?: boolean | undefined;
    entryFile?: string | null | undefined;
}, {
    type: "Applet.Version.CreateAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    binary: string | null;
    frontAppletVersion: string | null;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    bundledFrontApplet?: boolean | undefined;
    entryFile?: string | null | undefined;
}>>;
export declare const UpdateAppletVersion = "Applet.Version.UpdateAppletVersion";
export declare const UpdateAppletVersionSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Applet.Version.UpdateAppletVersion">;
    appletUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    version: z.ZodString;
    binary: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    frontAppletVersion: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    bundledFrontApplet: z.ZodOptional<z.ZodBoolean>;
    entryFile: z.ZodNullable<z.ZodOptional<z.ZodString>>;
}, "strict", z.ZodTypeAny, {
    type: "Applet.Version.UpdateAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    binary?: string | null | undefined;
    frontAppletVersion?: string | null | undefined;
    bundledFrontApplet?: boolean | undefined;
    entryFile?: string | null | undefined;
}, {
    type: "Applet.Version.UpdateAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    binary?: string | null | undefined;
    frontAppletVersion?: string | null | undefined;
    bundledFrontApplet?: boolean | undefined;
    entryFile?: string | null | undefined;
}>;
export type UpdateAppletVersion = z.infer<typeof UpdateAppletVersionSchema>;
export declare const UpdateAppletVersionFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    binary?: string | null | undefined;
    frontAppletVersion?: string | null | undefined;
    bundledFrontApplet?: boolean | undefined;
    entryFile?: string | null | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Applet.Version.UpdateAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    binary?: string | null | undefined;
    frontAppletVersion?: string | null | undefined;
    bundledFrontApplet?: boolean | undefined;
    entryFile?: string | null | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Applet.Version.UpdateAppletVersion">;
    appletUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    version: z.ZodString;
    binary: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    frontAppletVersion: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    bundledFrontApplet: z.ZodOptional<z.ZodBoolean>;
    entryFile: z.ZodNullable<z.ZodOptional<z.ZodString>>;
}, "strict", z.ZodTypeAny, {
    type: "Applet.Version.UpdateAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    binary?: string | null | undefined;
    frontAppletVersion?: string | null | undefined;
    bundledFrontApplet?: boolean | undefined;
    entryFile?: string | null | undefined;
}, {
    type: "Applet.Version.UpdateAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    binary?: string | null | undefined;
    frontAppletVersion?: string | null | undefined;
    bundledFrontApplet?: boolean | undefined;
    entryFile?: string | null | undefined;
}>>;
export declare const NotifyAppletVersionBuilt = "Applet.Version.NotifyAppletVersionBuilt";
export declare const NotifyAppletVersionBuiltSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Applet.Version.NotifyAppletVersionBuilt">;
    requestUid: z.ZodString;
    appletUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    version: z.ZodString;
    originator: z.ZodOptional<z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>>;
}, "strict", z.ZodTypeAny, {
    type: "Applet.Version.NotifyAppletVersionBuilt";
    version: string;
    appletUid: string;
    requestUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
}, {
    type: "Applet.Version.NotifyAppletVersionBuilt";
    version: string;
    appletUid: string;
    requestUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
}>;
export type NotifyAppletVersionBuilt = z.infer<typeof NotifyAppletVersionBuiltSchema>;
export declare const NotifyAppletVersionBuiltFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
} & {
    version: string;
    appletUid: string;
    requestUid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Applet.Version.NotifyAppletVersionBuilt";
    version: string;
    appletUid: string;
    requestUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Applet.Version.NotifyAppletVersionBuilt">;
    requestUid: z.ZodString;
    appletUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    version: z.ZodString;
    originator: z.ZodOptional<z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>>;
}, "strict", z.ZodTypeAny, {
    type: "Applet.Version.NotifyAppletVersionBuilt";
    version: string;
    appletUid: string;
    requestUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
}, {
    type: "Applet.Version.NotifyAppletVersionBuilt";
    version: string;
    appletUid: string;
    requestUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
}>>;
export declare const NotifyAppletVersionBuildFailed = "Applet.Version.NotifyAppletVersionBuildFailed";
export declare const NotifyAppletVersionBuildFailedSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Applet.Version.NotifyAppletVersionBuildFailed">;
    requestUid: z.ZodString;
    appletUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    version: z.ZodString;
    error: z.ZodUnion<[z.ZodObject<{
        name: z.ZodLiteral<"EcmaScriptSyntaxErrorSchema">;
        message: z.ZodString;
        pos: z.ZodNumber;
        loc: z.ZodObject<{
            line: z.ZodNumber;
            column: z.ZodNumber;
        }, "strip", z.ZodTypeAny, {
            line: number;
            column: number;
        }, {
            line: number;
            column: number;
        }>;
        codeFrame: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        name: "EcmaScriptSyntaxErrorSchema";
        message: string;
        pos: number;
        loc: {
            line: number;
            column: number;
        };
        codeFrame: string;
    }, {
        name: "EcmaScriptSyntaxErrorSchema";
        message: string;
        pos: number;
        loc: {
            line: number;
            column: number;
        };
        codeFrame: string;
    }>, z.ZodRecord<z.ZodString, z.ZodUnknown>]>;
}, "strict", z.ZodTypeAny, {
    type: "Applet.Version.NotifyAppletVersionBuildFailed";
    error: (Record<string, unknown> | {
        name: "EcmaScriptSyntaxErrorSchema";
        message: string;
        pos: number;
        loc: {
            line: number;
            column: number;
        };
        codeFrame: string;
    }) & (Record<string, unknown> | {
        name: "EcmaScriptSyntaxErrorSchema";
        message: string;
        pos: number;
        loc: {
            line: number;
            column: number;
        };
        codeFrame: string;
    } | undefined);
    version: string;
    appletUid: string;
    requestUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Applet.Version.NotifyAppletVersionBuildFailed";
    error: (Record<string, unknown> | {
        name: "EcmaScriptSyntaxErrorSchema";
        message: string;
        pos: number;
        loc: {
            line: number;
            column: number;
        };
        codeFrame: string;
    }) & (Record<string, unknown> | {
        name: "EcmaScriptSyntaxErrorSchema";
        message: string;
        pos: number;
        loc: {
            line: number;
            column: number;
        };
        codeFrame: string;
    } | undefined);
    version: string;
    appletUid: string;
    requestUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type NotifyAppletVersionBuildFailed = z.infer<typeof NotifyAppletVersionBuildFailedSchema>;
export declare const NotifyAppletVersionBuildFailedFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    error: (Record<string, unknown> | {
        name: "EcmaScriptSyntaxErrorSchema";
        message: string;
        pos: number;
        loc: {
            line: number;
            column: number;
        };
        codeFrame: string;
    }) & (Record<string, unknown> | {
        name: "EcmaScriptSyntaxErrorSchema";
        message: string;
        pos: number;
        loc: {
            line: number;
            column: number;
        };
        codeFrame: string;
    } | undefined);
    version: string;
    appletUid: string;
    requestUid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Applet.Version.NotifyAppletVersionBuildFailed";
    error: (Record<string, unknown> | {
        name: "EcmaScriptSyntaxErrorSchema";
        message: string;
        pos: number;
        loc: {
            line: number;
            column: number;
        };
        codeFrame: string;
    }) & (Record<string, unknown> | {
        name: "EcmaScriptSyntaxErrorSchema";
        message: string;
        pos: number;
        loc: {
            line: number;
            column: number;
        };
        codeFrame: string;
    } | undefined);
    version: string;
    appletUid: string;
    requestUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Applet.Version.NotifyAppletVersionBuildFailed">;
    requestUid: z.ZodString;
    appletUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    version: z.ZodString;
    error: z.ZodUnion<[z.ZodObject<{
        name: z.ZodLiteral<"EcmaScriptSyntaxErrorSchema">;
        message: z.ZodString;
        pos: z.ZodNumber;
        loc: z.ZodObject<{
            line: z.ZodNumber;
            column: z.ZodNumber;
        }, "strip", z.ZodTypeAny, {
            line: number;
            column: number;
        }, {
            line: number;
            column: number;
        }>;
        codeFrame: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        name: "EcmaScriptSyntaxErrorSchema";
        message: string;
        pos: number;
        loc: {
            line: number;
            column: number;
        };
        codeFrame: string;
    }, {
        name: "EcmaScriptSyntaxErrorSchema";
        message: string;
        pos: number;
        loc: {
            line: number;
            column: number;
        };
        codeFrame: string;
    }>, z.ZodRecord<z.ZodString, z.ZodUnknown>]>;
}, "strict", z.ZodTypeAny, {
    type: "Applet.Version.NotifyAppletVersionBuildFailed";
    error: (Record<string, unknown> | {
        name: "EcmaScriptSyntaxErrorSchema";
        message: string;
        pos: number;
        loc: {
            line: number;
            column: number;
        };
        codeFrame: string;
    }) & (Record<string, unknown> | {
        name: "EcmaScriptSyntaxErrorSchema";
        message: string;
        pos: number;
        loc: {
            line: number;
            column: number;
        };
        codeFrame: string;
    } | undefined);
    version: string;
    appletUid: string;
    requestUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Applet.Version.NotifyAppletVersionBuildFailed";
    error: (Record<string, unknown> | {
        name: "EcmaScriptSyntaxErrorSchema";
        message: string;
        pos: number;
        loc: {
            line: number;
            column: number;
        };
        codeFrame: string;
    }) & (Record<string, unknown> | {
        name: "EcmaScriptSyntaxErrorSchema";
        message: string;
        pos: number;
        loc: {
            line: number;
            column: number;
        };
        codeFrame: string;
    } | undefined);
    version: string;
    appletUid: string;
    requestUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const PublishAppletVersion = "Applet.Version.PublishAppletVersion";
export declare const PublishAppletVersionSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Applet.Version.PublishAppletVersion">;
    appletUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    version: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Applet.Version.PublishAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Applet.Version.PublishAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type PublishAppletVersion = z.infer<typeof PublishAppletVersionSchema>;
export declare const PublishAppletVersionFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Applet.Version.PublishAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Applet.Version.PublishAppletVersion">;
    appletUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    version: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Applet.Version.PublishAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Applet.Version.PublishAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const DeprecateAppletVersion = "Applet.Version.DeprecateAppletVersion";
export declare const DeprecateAppletVersionSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Applet.Version.DeprecateAppletVersion">;
    appletUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    version: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Applet.Version.DeprecateAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Applet.Version.DeprecateAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type DeprecateAppletVersion = z.infer<typeof DeprecateAppletVersionSchema>;
export declare const DeprecateAppletVersionFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Applet.Version.DeprecateAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Applet.Version.DeprecateAppletVersion">;
    appletUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    version: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Applet.Version.DeprecateAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Applet.Version.DeprecateAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const RenewAppletVersion = "Applet.Version.RenewAppletVersion";
export declare const RenewAppletVersionSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Applet.Version.RenewAppletVersion">;
    appletUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    version: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Applet.Version.RenewAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Applet.Version.RenewAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type RenewAppletVersion = z.infer<typeof RenewAppletVersionSchema>;
export declare const RenewAppletVersionFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Applet.Version.RenewAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Applet.Version.RenewAppletVersion">;
    appletUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    version: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Applet.Version.RenewAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Applet.Version.RenewAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const DeleteAppletVersion = "Applet.Version.DeleteAppletVersion";
export declare const DeleteAppletVersionSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Applet.Version.DeleteAppletVersion">;
    appletUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    version: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Applet.Version.DeleteAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Applet.Version.DeleteAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type DeleteAppletVersion = z.infer<typeof DeleteAppletVersionSchema>;
export declare const DeleteAppletVersionFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Applet.Version.DeleteAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Applet.Version.DeleteAppletVersion">;
    appletUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    version: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Applet.Version.DeleteAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Applet.Version.DeleteAppletVersion";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    version: string;
    appletUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
