"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnpauseAlertRule = exports.PauseAlertRule = exports.UnarchiveAlertRule = exports.ArchiveAlertRule = exports.UpdateAlertRule = exports.CreateAlertRule = void 0;
/**
 * Creates an empty alert rule only with name and uid.
 * @see @signageos/common/devices It's generic and has to accept AlertRule props from lib
 */
exports.CreateAlertRule = 'Alert.CreateAlertRule';
/**
 * Updates existing alert rule by it's uid.
 * @see @signageos/common/devices It's generic and has to accept AlertRule props from lib
 */
exports.UpdateAlertRule = 'Alert.UpdateAlertRule';
/**
 * Archive existing alert rule by it's uid.
 * It's practically removed, because it cannot be recovered.
 * @see @signageos/common/devices It's generic and has to accept AlertRule props from lib
 */
exports.ArchiveAlertRule = 'Alert.ArchiveAlertRule';
/**
 * Unarchive existing alert rule by it's uid.
 * @see @signageos/common/devices It's generic and has to accept AlertRule props from lib
 */
exports.UnarchiveAlertRule = 'Alert.UnarchiveAlertRule';
/**
 * Pause checking of rule until it's unpause.
 * It temporarily stop any checking of violations & alert creation/update.
 * @see @signageos/common/devices It's generic and has to accept AlertRule props from lib
 */
exports.PauseAlertRule = 'Alert.PauseAlertRule';
/**
 * Unpause checking of rule and start checking it again.
 * @see @signageos/common/devices It's generic and has to accept AlertRule props from lib
 */
exports.UnpauseAlertRule = 'Alert.UnpauseAlertRule';
//# sourceMappingURL=alertRuleCommands.js.map