import { IOriginatorAwareCommand } from '../ICommand';
/**
 * Creates an empty alert rule only with name and uid.
 * @see @signageos/common/devices It's generic and has to accept AlertRule props from lib
 */
export declare const CreateAlertRule = "Alert.CreateAlertRule";
export type CreateAlertRule<AlertRuleCreatable> = IOriginatorAwareCommand<typeof CreateAlertRule> & AlertRuleCreatable;
/**
 * Updates existing alert rule by it's uid.
 * @see @signageos/common/devices It's generic and has to accept AlertRule props from lib
 */
export declare const UpdateAlertRule = "Alert.UpdateAlertRule";
export type UpdateAlertRule<AlertRuleUpdatable> = IOriginatorAwareCommand<typeof UpdateAlertRule> & AlertRuleUpdatable;
/**
 * Archive existing alert rule by it's uid.
 * It's practically removed, because it cannot be recovered.
 * @see @signageos/common/devices It's generic and has to accept AlertRule props from lib
 */
export declare const ArchiveAlertRule = "Alert.ArchiveAlertRule";
export type ArchiveAlertRule<AlertRuleIdentifiable> = IOriginatorAwareCommand<typeof ArchiveAlertRule> & AlertRuleIdentifiable;
/**
 * Unarchive existing alert rule by it's uid.
 * @see @signageos/common/devices It's generic and has to accept AlertRule props from lib
 */
export declare const UnarchiveAlertRule = "Alert.UnarchiveAlertRule";
export type UnarchiveAlertRule<AlertRuleIdentifiable> = IOriginatorAwareCommand<typeof UnarchiveAlertRule> & AlertRuleIdentifiable;
/**
 * Pause checking of rule until it's unpause.
 * It temporarily stop any checking of violations & alert creation/update.
 * @see @signageos/common/devices It's generic and has to accept AlertRule props from lib
 */
export declare const PauseAlertRule = "Alert.PauseAlertRule";
export type PauseAlertRule<AlertRuleIdentifiable> = IOriginatorAwareCommand<typeof PauseAlertRule> & AlertRuleIdentifiable;
/**
 * Unpause checking of rule and start checking it again.
 * @see @signageos/common/devices It's generic and has to accept AlertRule props from lib
 */
export declare const UnpauseAlertRule = "Alert.UnpauseAlertRule";
export type UnpauseAlertRule<AlertRuleIdentifiable> = IOriginatorAwareCommand<typeof UnpauseAlertRule> & AlertRuleIdentifiable;
