"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResolveAlertForDeviceFactory = exports.ResolveAlertForDeviceSchema = exports.ResolveAlertForDevice = exports.UnsnoozeDeviceAlertFactory = exports.UnsnoozeDeviceAlertSchema = exports.UnsnoozeDeviceAlert = exports.SnoozeDeviceAlertFactory = exports.SnoozeDeviceAlertSchema = exports.SnoozeDeviceAlert = exports.DateTimeSnoozeRuleSchema = exports.UnsnoozeAlert = exports.SnoozeAlert = exports.UnarchiveAlert = exports.ArchiveAlert = exports.UpdateAlert = exports.UnassignDevicesFromAlert = exports.AssignDevicesToAlert = exports.CreateAlert = void 0;
const deviceCommands_1 = require("../Device/deviceCommands");
const ICommand_1 = require("../ICommand");
const zod_1 = require("zod");
const commandFactory_1 = require("../commandFactory");
const schemas_1 = require("../schemas");
/**
 * Create an alert based on AlertRule when conditions and thresholds are reached.
 */
exports.CreateAlert = 'Alert.CreateAlert';
/**
 * Add many devices to already created alert.
 * Alert can have one to many devices assigned.
 * Assigning of new devices can be done anytime even later when some device start matching AlertRule condition.
 */
exports.AssignDevicesToAlert = 'Alert.AssignDevicesToAlert';
/**
 * Remove many devices from already created and assigned alert.
 * Unassign can happen on not archived alerts when AlertRule found some device stopped matching conditions.
 */
exports.UnassignDevicesFromAlert = 'Alert.UnassignDevicesFromAlert';
/**
 * User can adjust alert.
 */
exports.UpdateAlert = 'Alert.UpdateAlert';
/**
 * Archiving alert make it invisible for the standard logic of system. Only user can see it in something like trash
 * and can unarchive it later.
 */
exports.ArchiveAlert = 'Alert.ArchiveAlert';
/**
 * Unarchiving alert make it again visible for the standard logic of system. User can do it on purpose.
 * Be careful. When alert is unarchived, it can start conflicting with another active rule. System has to count with this option
 * and work only with last created alert.
 */
exports.UnarchiveAlert = 'Alert.UnarchiveAlert';
/**
 * User can snooze alert for later. This is mostly UI logic which makes alert invisible until specified snooze rule is meet.
 * The rest of system will overlook this snooze state. Only notifications are silenced.
 */
exports.SnoozeAlert = 'Alert.SnoozeAlert';
/**
 * Reverts the last snooze action as it's not happened.
 */
exports.UnsnoozeAlert = 'Alert.UnsnoozeAlert';
exports.DateTimeSnoozeRuleSchema = zod_1.z
    .object({
    type: zod_1.z.literal('datetime'),
    snoozedUntil: zod_1.z.date(),
})
    .strict();
exports.SnoozeDeviceAlert = 'Alert.SnoozeDeviceAlert';
exports.SnoozeDeviceAlertSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.SnoozeDeviceAlert),
    alertUid: schemas_1.UIDSchema.or(schemas_1.LegacyUIDSchema),
    deviceIdentityHash: deviceCommands_1.DeviceIdentityHashSchema,
    snoozeRule: exports.DateTimeSnoozeRuleSchema,
}).strict();
exports.SnoozeDeviceAlertFactory = (0, commandFactory_1.createCommandFactory)(exports.SnoozeDeviceAlertSchema);
exports.UnsnoozeDeviceAlert = 'Alert.UnsnoozeDeviceAlert';
exports.UnsnoozeDeviceAlertSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.UnsnoozeDeviceAlert),
    alertUid: schemas_1.UIDSchema.or(schemas_1.LegacyUIDSchema),
    deviceIdentityHash: deviceCommands_1.DeviceIdentityHashSchema,
}).strict();
exports.UnsnoozeDeviceAlertFactory = (0, commandFactory_1.createCommandFactory)(exports.UnsnoozeDeviceAlertSchema);
exports.ResolveAlertForDevice = 'Alert.ResolveAlertForDevice';
exports.ResolveAlertForDeviceSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.ResolveAlertForDevice),
    alertUid: schemas_1.UIDSchema.or(schemas_1.LegacyUIDSchema),
    deviceIdentityHash: deviceCommands_1.DeviceIdentityHashSchema,
}).strict();
exports.ResolveAlertForDeviceFactory = (0, commandFactory_1.createCommandFactory)(exports.ResolveAlertForDeviceSchema);
//# sourceMappingURL=alertCommands.js.map