import ICommand, { IOriginatorAwareCommand } from '../ICommand';
import { z } from 'zod';
/**
 * Create an alert based on AlertRule when conditions and thresholds are reached.
 */
export declare const CreateAlert = "Alert.CreateAlert";
export type CreateAlert<AlertCreatable> = ICommand<typeof CreateAlert> & AlertCreatable;
/**
 * Add many devices to already created alert.
 * Alert can have one to many devices assigned.
 * Assigning of new devices can be done anytime even later when some device start matching AlertRule condition.
 */
export declare const AssignDevicesToAlert = "Alert.AssignDevicesToAlert";
export type AssignDevicesToAlert<AlertIdentifiable> = ICommand<typeof AssignDevicesToAlert> & AlertIdentifiable & {
    deviceIdentityHashes: string[];
};
/**
 * Remove many devices from already created and assigned alert.
 * Unassign can happen on not archived alerts when AlertRule found some device stopped matching conditions.
 */
export declare const UnassignDevicesFromAlert = "Alert.UnassignDevicesFromAlert";
export type UnassignDevicesFromAlert<AlertIdentifiable> = ICommand<typeof UnassignDevicesFromAlert> & AlertIdentifiable & {
    deviceIdentityHashes: string[];
} & {
    originator?: IOriginatorAwareCommand<typeof UnassignDevicesFromAlert>['originator'];
};
/**
 * User can adjust alert.
 */
export declare const UpdateAlert = "Alert.UpdateAlert";
export type UpdateAlert<AlertUpdatable> = IOriginatorAwareCommand<typeof UpdateAlert> & AlertUpdatable;
/**
 * Archiving alert make it invisible for the standard logic of system. Only user can see it in something like trash
 * and can unarchive it later.
 */
export declare const ArchiveAlert = "Alert.ArchiveAlert";
export type ArchiveAlert<AlertIdentifiable> = IOriginatorAwareCommand<typeof ArchiveAlert> & AlertIdentifiable;
/**
 * Unarchiving alert make it again visible for the standard logic of system. User can do it on purpose.
 * Be careful. When alert is unarchived, it can start conflicting with another active rule. System has to count with this option
 * and work only with last created alert.
 */
export declare const UnarchiveAlert = "Alert.UnarchiveAlert";
export type UnarchiveAlert<AlertIdentifiable> = IOriginatorAwareCommand<typeof UnarchiveAlert> & AlertIdentifiable;
/**
 * User can snooze alert for later. This is mostly UI logic which makes alert invisible until specified snooze rule is meet.
 * The rest of system will overlook this snooze state. Only notifications are silenced.
 */
export declare const SnoozeAlert = "Alert.SnoozeAlert";
export type SnoozeAlert<AlertSnoozable> = IOriginatorAwareCommand<typeof SnoozeAlert> & AlertSnoozable;
/**
 * Reverts the last snooze action as it's not happened.
 */
export declare const UnsnoozeAlert = "Alert.UnsnoozeAlert";
export type UnsnoozeAlert<AlertIdentifiable> = IOriginatorAwareCommand<typeof UnsnoozeAlert> & AlertIdentifiable;
export declare const DateTimeSnoozeRuleSchema: z.ZodObject<{
    type: z.ZodLiteral<"datetime">;
    snoozedUntil: z.ZodDate;
}, "strict", z.ZodTypeAny, {
    type: "datetime";
    snoozedUntil: Date;
}, {
    type: "datetime";
    snoozedUntil: Date;
}>;
export declare const SnoozeDeviceAlert = "Alert.SnoozeDeviceAlert";
export declare const SnoozeDeviceAlertSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Alert.SnoozeDeviceAlert">;
    alertUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    deviceIdentityHash: z.ZodString;
    snoozeRule: z.ZodObject<{
        type: z.ZodLiteral<"datetime">;
        snoozedUntil: z.ZodDate;
    }, "strict", z.ZodTypeAny, {
        type: "datetime";
        snoozedUntil: Date;
    }, {
        type: "datetime";
        snoozedUntil: Date;
    }>;
}, "strict", z.ZodTypeAny, {
    type: "Alert.SnoozeDeviceAlert";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    alertUid: string;
    snoozeRule: {
        type: "datetime";
        snoozedUntil: Date;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Alert.SnoozeDeviceAlert";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    alertUid: string;
    snoozeRule: {
        type: "datetime";
        snoozedUntil: Date;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type SnoozeDeviceAlert = z.infer<typeof SnoozeDeviceAlertSchema>;
export declare const SnoozeDeviceAlertFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    alertUid: string;
    snoozeRule: {
        type: "datetime";
        snoozedUntil: Date;
    };
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Alert.SnoozeDeviceAlert";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    alertUid: string;
    snoozeRule: {
        type: "datetime";
        snoozedUntil: Date;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Alert.SnoozeDeviceAlert">;
    alertUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    deviceIdentityHash: z.ZodString;
    snoozeRule: z.ZodObject<{
        type: z.ZodLiteral<"datetime">;
        snoozedUntil: z.ZodDate;
    }, "strict", z.ZodTypeAny, {
        type: "datetime";
        snoozedUntil: Date;
    }, {
        type: "datetime";
        snoozedUntil: Date;
    }>;
}, "strict", z.ZodTypeAny, {
    type: "Alert.SnoozeDeviceAlert";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    alertUid: string;
    snoozeRule: {
        type: "datetime";
        snoozedUntil: Date;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Alert.SnoozeDeviceAlert";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    alertUid: string;
    snoozeRule: {
        type: "datetime";
        snoozedUntil: Date;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const UnsnoozeDeviceAlert = "Alert.UnsnoozeDeviceAlert";
export declare const UnsnoozeDeviceAlertSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Alert.UnsnoozeDeviceAlert">;
    alertUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    deviceIdentityHash: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Alert.UnsnoozeDeviceAlert";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    alertUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Alert.UnsnoozeDeviceAlert";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    alertUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type UnsnoozeDeviceAlert = z.infer<typeof UnsnoozeDeviceAlertSchema>;
export declare const UnsnoozeDeviceAlertFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    alertUid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Alert.UnsnoozeDeviceAlert";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    alertUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Alert.UnsnoozeDeviceAlert">;
    alertUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    deviceIdentityHash: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Alert.UnsnoozeDeviceAlert";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    alertUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Alert.UnsnoozeDeviceAlert";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    alertUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const ResolveAlertForDevice = "Alert.ResolveAlertForDevice";
export declare const ResolveAlertForDeviceSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Alert.ResolveAlertForDevice">;
    alertUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    deviceIdentityHash: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Alert.ResolveAlertForDevice";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    alertUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Alert.ResolveAlertForDevice";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    alertUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type ResolveAlertForDevice = z.infer<typeof ResolveAlertForDeviceSchema>;
export declare const ResolveAlertForDeviceFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    alertUid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Alert.ResolveAlertForDevice";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    alertUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Alert.ResolveAlertForDevice">;
    alertUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    deviceIdentityHash: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Alert.ResolveAlertForDevice";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    alertUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Alert.ResolveAlertForDevice";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    alertUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
