import { z } from 'zod';
/**
 * Use @signageos/lib/dist/Encryption/passwordEncryption module to hash the password
 *
 * @example
 * ```ts
 * import { preEncryptPassword, encryptPassword } from '@signageos/lib/dist/Encryption/passwordEncryption';
 * import { generateSalt } from '@signageos/lib/dist/Hash/generator';
 *
 * const password = 'password';
 * const salt = generateSalt();
 * const preEncryptedPassword = preEncryptPassword(password);
 * const encryptedPassword = await encryptPassword(preEncryptedPassword, salt);
 * ```
 */
export declare const PasswordHashSchema: z.ZodString;
export declare const SaltSchema: z.ZodString;
