"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetWelcomeDashboardSectionsAppearanceFactory = exports.SetWelcomeDashboardSectionsAppearanceSchema = exports.SetWelcomeDashboardSectionsAppearance = exports.SetAccountEmailNotificationsNewsletterFactory = exports.SetAccountEmailNotificationsNewsletterSchema = exports.SetAccountEmailNotificationsNewsletter = exports.SetAccountEmailNotificationsAlertLevelFactory = exports.SetAccountEmailNotificationsAlertLevelSchema = exports.SetAccountEmailNotificationsAlertLevel = exports.SetAccountTimezoneFactory = exports.SetAccountTimezoneSchema = exports.SetAccountTimezone = exports.ResetPasswordFactory = exports.ResetPasswordSchema = exports.ResetPassword = exports.SetPasswordFactory = exports.SetPasswordSchema = exports.SetPassword = exports.ClearAPISecurityTokensFactory = exports.ClearAPISecurityTokensSchema = exports.ClearAPISecurityTokens = exports.RemoveAPISecurityTokenFactory = exports.RemoveAPISecurityTokenSchema = exports.RemoveAPISecurityToken = exports.AddAPISecurityTokenFactory = exports.AddAPISecurityTokenSchema = exports.AddAPISecurityToken = exports.SetAPISecurityTokenFactory = exports.SetAPISecurityTokenSchema = exports.SetAPISecurityToken = exports.ChangeEmailFactory = exports.ChangeEmailSchema = exports.ChangeEmail = void 0;
const zod_1 = require("zod");
const commandFactory_1 = require("../commandFactory");
const ICommand_1 = require("../ICommand");
const organizationCommands_1 = require("../Organization/organizationCommands");
const accountCommands_1 = require("./accountCommands");
const schemas_1 = require("./schemas");
const TokenIDSchema = zod_1.z.string().length(20);
const TokenSchema = zod_1.z.string().length(40).or(zod_1.z.string().length(64));
exports.ChangeEmail = 'Account.Settings.ChangeEmail';
exports.ChangeEmailSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.ChangeEmail),
    accountId: accountCommands_1.AccountIdSchema,
    email: zod_1.z.string().email(),
}).strict();
exports.ChangeEmailFactory = (0, commandFactory_1.createCommandFactory)(exports.ChangeEmailSchema);
/** @deprecated Use AddAPISecurityToken instead */
exports.SetAPISecurityToken = 'Account.Settings.SetAPISecurityToken';
/** @deprecated Use AddAPISecurityToken instead */
exports.SetAPISecurityTokenSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.SetAPISecurityToken),
    accountId: accountCommands_1.AccountIdSchema,
    token: zod_1.z.string(),
    salt: zod_1.z.string(),
    name: zod_1.z.string().optional(),
}).strict();
/** @deprecated Use AddAPISecurityToken instead */
exports.SetAPISecurityTokenFactory = (0, commandFactory_1.createCommandFactory)(exports.SetAPISecurityTokenSchema);
exports.AddAPISecurityToken = 'Account.Settings.AddAPISecurityToken';
exports.AddAPISecurityTokenSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.AddAPISecurityToken),
    id: TokenIDSchema,
    accountId: accountCommands_1.AccountIdSchema,
    token: TokenSchema,
    salt: schemas_1.SaltSchema,
    name: zod_1.z.string().max(200).optional(),
    version: zod_1.z.number(),
    organizationUid: organizationCommands_1.OrganizationUIDSchema.optional(),
});
exports.AddAPISecurityTokenFactory = (0, commandFactory_1.createCommandFactory)(exports.AddAPISecurityTokenSchema);
exports.RemoveAPISecurityToken = 'Account.Settings.RemoveAPISecurityToken';
exports.RemoveAPISecurityTokenSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.RemoveAPISecurityToken),
    accountId: accountCommands_1.AccountIdSchema,
    id: TokenIDSchema,
});
exports.RemoveAPISecurityTokenFactory = (0, commandFactory_1.createCommandFactory)(exports.RemoveAPISecurityTokenSchema);
exports.ClearAPISecurityTokens = 'Account.Settings.ClearAPISecurityTokens';
exports.ClearAPISecurityTokensSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.ClearAPISecurityTokens),
    accountId: accountCommands_1.AccountIdSchema,
});
exports.ClearAPISecurityTokensFactory = (0, commandFactory_1.createCommandFactory)(exports.ClearAPISecurityTokensSchema);
exports.SetPassword = 'Account.Settings.SetPassword';
exports.SetPasswordSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.SetPassword),
    accountId: accountCommands_1.AccountIdSchema,
    /** Password hash */
    password: schemas_1.PasswordHashSchema,
    /** Salt used to hash the password */
    salt: schemas_1.SaltSchema,
});
exports.SetPasswordFactory = (0, commandFactory_1.createCommandFactory)(exports.SetPasswordSchema);
exports.ResetPassword = 'Account.Settings.ResetPassword';
exports.ResetPasswordSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.ResetPassword),
    accountId: accountCommands_1.AccountIdSchema,
});
exports.ResetPasswordFactory = (0, commandFactory_1.createCommandFactory)(exports.ResetPasswordSchema);
exports.SetAccountTimezone = 'Account.Settings.SetAccountTimezone';
exports.SetAccountTimezoneSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.SetAccountTimezone),
    accountId: accountCommands_1.AccountIdSchema,
    timezone: zod_1.z.string().max(100),
});
exports.SetAccountTimezoneFactory = (0, commandFactory_1.createCommandFactory)(exports.SetAccountTimezoneSchema);
exports.SetAccountEmailNotificationsAlertLevel = 'Account.Settings.SetAccountEmailNotificationsAlertLevel';
exports.SetAccountEmailNotificationsAlertLevelSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.SetAccountEmailNotificationsAlertLevel),
    accountId: accountCommands_1.AccountIdSchema,
    alertLevels: zod_1.z.array(zod_1.z.union([zod_1.z.literal('info'), zod_1.z.literal('warning'), zod_1.z.literal('error')])),
});
exports.SetAccountEmailNotificationsAlertLevelFactory = (0, commandFactory_1.createCommandFactory)(exports.SetAccountEmailNotificationsAlertLevelSchema);
exports.SetAccountEmailNotificationsNewsletter = 'Account.Settings.SetAccountEmailNotificationsNewsletter';
exports.SetAccountEmailNotificationsNewsletterSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.SetAccountEmailNotificationsNewsletter),
    accountId: accountCommands_1.AccountIdSchema,
    isSubscribedToNewsletter: zod_1.z.boolean(),
});
exports.SetAccountEmailNotificationsNewsletterFactory = (0, commandFactory_1.createCommandFactory)(exports.SetAccountEmailNotificationsNewsletterSchema);
exports.SetWelcomeDashboardSectionsAppearance = 'Account.Settings.SetWelcomeDashboardSectionsAppearance';
exports.SetWelcomeDashboardSectionsAppearanceSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.SetWelcomeDashboardSectionsAppearance),
    accountId: accountCommands_1.AccountIdSchema,
    sectionsAppearance: zod_1.z.record(zod_1.z.string().max(100)),
});
exports.SetWelcomeDashboardSectionsAppearanceFactory = (0, commandFactory_1.createCommandFactory)(exports.SetWelcomeDashboardSectionsAppearanceSchema);
//# sourceMappingURL=accountSettingsCommands.js.map