import { z } from 'zod';
import { Role } from '@signageos/common-types/dist/Account/Account';
import { NumericIdSchema as AccountIdSchema } from '../schemas';
export { AccountIdSchema };
export declare const CreateAccount = "Account.CreateAccount";
/**
 * @passwordSecurityToken - token for password setting email
 */
export declare const CreateAccountSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.CreateAccount">;
    id: z.ZodDefault<z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>>;
    username: z.ZodOptional<z.ZodString>;
    email: z.ZodString;
    firstname: z.ZodOptional<z.ZodEffects<z.ZodString, string, string>>;
    lastname: z.ZodOptional<z.ZodEffects<z.ZodString, string, string>>;
    accessLevel: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Account/Account").AccessLevel>;
    reason: z.ZodOptional<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Account/Account").AccountCreationReason>>;
    passwordSecurityToken: z.ZodDefault<z.ZodString>;
    createdAt: z.ZodDefault<z.ZodDate>;
    whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
    activate: z.ZodOptional<z.ZodBoolean>;
    password: z.ZodOptional<z.ZodObject<{
        /** Password hash */
        password: z.ZodString;
        /** Salt used to hash the password */
        salt: z.ZodString;
    }, "strict", z.ZodTypeAny, {
        password: string;
        salt: string;
    }, {
        password: string;
        salt: string;
    }>>;
}, "strict", z.ZodTypeAny, {
    type: "Account.CreateAccount";
    id: number;
    email: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    accessLevel: import("@signageos/common-types/dist/Account/Account").AccessLevel;
    passwordSecurityToken: string;
    createdAt: Date;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    username?: string | undefined;
    firstname?: string | undefined;
    lastname?: string | undefined;
    reason?: import("@signageos/common-types/dist/Account/Account").AccountCreationReason | undefined;
    whiteLabelSettingsUid?: string | undefined;
    activate?: boolean | undefined;
    password?: {
        password: string;
        salt: string;
    } | undefined;
}, {
    type: "Account.CreateAccount";
    email: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    accessLevel: import("@signageos/common-types/dist/Account/Account").AccessLevel;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    id?: string | number | undefined;
    username?: string | undefined;
    firstname?: string | undefined;
    lastname?: string | undefined;
    reason?: import("@signageos/common-types/dist/Account/Account").AccountCreationReason | undefined;
    passwordSecurityToken?: string | undefined;
    createdAt?: Date | undefined;
    whiteLabelSettingsUid?: string | undefined;
    activate?: boolean | undefined;
    password?: {
        password: string;
        salt: string;
    } | undefined;
}>;
export type CreateAccount = z.infer<typeof CreateAccountSchema>;
export declare const CreateAccountFactory: (data: {
    reason?: import("@signageos/common-types/dist/Account/Account").AccountCreationReason | undefined;
    username?: string | undefined;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    whiteLabelSettingsUid?: string | undefined;
    firstname?: string | undefined;
    lastname?: string | undefined;
    activate?: boolean | undefined;
    password?: {
        password: string;
        salt: string;
    } | undefined;
} & {
    email: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    accessLevel: import("@signageos/common-types/dist/Account/Account").AccessLevel;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.CreateAccount";
    id: number;
    email: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    accessLevel: import("@signageos/common-types/dist/Account/Account").AccessLevel;
    passwordSecurityToken: string;
    createdAt: Date;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    username?: string | undefined;
    firstname?: string | undefined;
    lastname?: string | undefined;
    reason?: import("@signageos/common-types/dist/Account/Account").AccountCreationReason | undefined;
    whiteLabelSettingsUid?: string | undefined;
    activate?: boolean | undefined;
    password?: {
        password: string;
        salt: string;
    } | undefined;
}, {
    id: () => number;
    passwordSecurityToken: () => string;
    createdAt: () => Date;
}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.CreateAccount">;
    id: z.ZodDefault<z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>>;
    username: z.ZodOptional<z.ZodString>;
    email: z.ZodString;
    firstname: z.ZodOptional<z.ZodEffects<z.ZodString, string, string>>;
    lastname: z.ZodOptional<z.ZodEffects<z.ZodString, string, string>>;
    accessLevel: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Account/Account").AccessLevel>;
    reason: z.ZodOptional<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Account/Account").AccountCreationReason>>;
    passwordSecurityToken: z.ZodDefault<z.ZodString>;
    createdAt: z.ZodDefault<z.ZodDate>;
    whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
    activate: z.ZodOptional<z.ZodBoolean>;
    password: z.ZodOptional<z.ZodObject<{
        /** Password hash */
        password: z.ZodString;
        /** Salt used to hash the password */
        salt: z.ZodString;
    }, "strict", z.ZodTypeAny, {
        password: string;
        salt: string;
    }, {
        password: string;
        salt: string;
    }>>;
}, "strict", z.ZodTypeAny, {
    type: "Account.CreateAccount";
    id: number;
    email: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    accessLevel: import("@signageos/common-types/dist/Account/Account").AccessLevel;
    passwordSecurityToken: string;
    createdAt: Date;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    username?: string | undefined;
    firstname?: string | undefined;
    lastname?: string | undefined;
    reason?: import("@signageos/common-types/dist/Account/Account").AccountCreationReason | undefined;
    whiteLabelSettingsUid?: string | undefined;
    activate?: boolean | undefined;
    password?: {
        password: string;
        salt: string;
    } | undefined;
}, {
    type: "Account.CreateAccount";
    email: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    accessLevel: import("@signageos/common-types/dist/Account/Account").AccessLevel;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    id?: string | number | undefined;
    username?: string | undefined;
    firstname?: string | undefined;
    lastname?: string | undefined;
    reason?: import("@signageos/common-types/dist/Account/Account").AccountCreationReason | undefined;
    passwordSecurityToken?: string | undefined;
    createdAt?: Date | undefined;
    whiteLabelSettingsUid?: string | undefined;
    activate?: boolean | undefined;
    password?: {
        password: string;
        salt: string;
    } | undefined;
}>>;
/**
 * Should be used for account creation, which will not be used for authentication trough our system.
 * Auth of this account will be handled via with 3rd party service e.g.: auth0
 *
 * @deprecated Use CreateAccount
 */
export declare const CreateSimpleAccount = "Account.CreateSimpleAccount";
/** @deprecated use CreateAccount */
export declare const CreateSimpleAccountSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.CreateSimpleAccount">;
    id: z.ZodNumber;
    email: z.ZodString;
    accessLevel: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Account/Account").AccessLevel>;
}, "strict", z.ZodTypeAny, {
    type: "Account.CreateSimpleAccount";
    id: number;
    email: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    accessLevel: import("@signageos/common-types/dist/Account/Account").AccessLevel;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.CreateSimpleAccount";
    id: number;
    email: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    accessLevel: import("@signageos/common-types/dist/Account/Account").AccessLevel;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
/** @deprecated use CreateAccount */
export type CreateSimpleAccount = z.infer<typeof CreateSimpleAccountSchema>;
/** @deprecated use CreateAccount */
export declare const CreateSimpleAccountFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    email: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    accessLevel: import("@signageos/common-types/dist/Account/Account").AccessLevel;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.CreateSimpleAccount";
    id: number;
    email: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    accessLevel: import("@signageos/common-types/dist/Account/Account").AccessLevel;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    id: () => number;
}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.CreateSimpleAccount">;
    id: z.ZodNumber;
    email: z.ZodString;
    accessLevel: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Account/Account").AccessLevel>;
}, "strict", z.ZodTypeAny, {
    type: "Account.CreateSimpleAccount";
    id: number;
    email: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    accessLevel: import("@signageos/common-types/dist/Account/Account").AccessLevel;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.CreateSimpleAccount";
    id: number;
    email: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    accessLevel: import("@signageos/common-types/dist/Account/Account").AccessLevel;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const ResendAccountActivationEmail = "Account.ResendActivationEmail";
export declare const ResendAccountActivationEmailSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.ResendActivationEmail">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    companyUid: z.ZodOptional<z.ZodString>;
    reason: z.ZodUnion<[z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Account/Account").AccountCreationReason>, z.ZodUndefined]>;
    whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
}, "strict", z.ZodTypeAny, {
    type: "Account.ResendActivationEmail";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    companyUid?: string | undefined;
    reason?: import("@signageos/common-types/dist/Account/Account").AccountCreationReason | undefined;
    whiteLabelSettingsUid?: string | undefined;
}, {
    type: "Account.ResendActivationEmail";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    companyUid?: string | undefined;
    reason?: import("@signageos/common-types/dist/Account/Account").AccountCreationReason | undefined;
    whiteLabelSettingsUid?: string | undefined;
}>;
export type ResendAccountActivationEmail = z.infer<typeof ResendAccountActivationEmailSchema>;
export declare const ResendAccountActivationEmailFactory: (data: {
    reason?: import("@signageos/common-types/dist/Account/Account").AccountCreationReason | undefined;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    whiteLabelSettingsUid?: string | undefined;
    companyUid?: string | undefined;
} & {
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.ResendActivationEmail";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    companyUid?: string | undefined;
    reason?: import("@signageos/common-types/dist/Account/Account").AccountCreationReason | undefined;
    whiteLabelSettingsUid?: string | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.ResendActivationEmail">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    companyUid: z.ZodOptional<z.ZodString>;
    reason: z.ZodUnion<[z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Account/Account").AccountCreationReason>, z.ZodUndefined]>;
    whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
}, "strict", z.ZodTypeAny, {
    type: "Account.ResendActivationEmail";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    companyUid?: string | undefined;
    reason?: import("@signageos/common-types/dist/Account/Account").AccountCreationReason | undefined;
    whiteLabelSettingsUid?: string | undefined;
}, {
    type: "Account.ResendActivationEmail";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    companyUid?: string | undefined;
    reason?: import("@signageos/common-types/dist/Account/Account").AccountCreationReason | undefined;
    whiteLabelSettingsUid?: string | undefined;
}>>;
/** @deprecated Use ResendAccountActivationEmail instead */
export declare const ResendActivationEmail = "Account.ResendActivationEmail";
/** @deprecated Use ResendAccountActivationEmail instead */
export type ResendActivationEmail = ResendAccountActivationEmail;
export declare const UpdateAccountAccessLevel = "Account.UpdateAccountAccessLevel";
export declare const UpdateAccountAccessLevelSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.UpdateAccountAccessLevel">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    accessLevel: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Account/Account").AccessLevel>;
}, "strict", z.ZodTypeAny, {
    type: "Account.UpdateAccountAccessLevel";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    accessLevel: import("@signageos/common-types/dist/Account/Account").AccessLevel;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.UpdateAccountAccessLevel";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    accessLevel: import("@signageos/common-types/dist/Account/Account").AccessLevel;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type UpdateAccountAccessLevel = z.infer<typeof UpdateAccountAccessLevelSchema>;
export declare const UpdateAccountAccessLevelFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    accessLevel: import("@signageos/common-types/dist/Account/Account").AccessLevel;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.UpdateAccountAccessLevel";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    accessLevel: import("@signageos/common-types/dist/Account/Account").AccessLevel;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.UpdateAccountAccessLevel">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    accessLevel: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Account/Account").AccessLevel>;
}, "strict", z.ZodTypeAny, {
    type: "Account.UpdateAccountAccessLevel";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    accessLevel: import("@signageos/common-types/dist/Account/Account").AccessLevel;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.UpdateAccountAccessLevel";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    accessLevel: import("@signageos/common-types/dist/Account/Account").AccessLevel;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const AddAccountToCompany = "Account.AddAccountToCompany";
export declare const AddAccountToCompanySchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.AddAccountToCompany">;
    email: z.ZodString;
    companyUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    role: z.ZodNativeEnum<typeof Role>;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
}, "strict", z.ZodTypeAny, {
    type: "Account.AddAccountToCompany";
    role: Role;
    email: string;
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    whiteLabelSettingsUid?: string | undefined;
}, {
    type: "Account.AddAccountToCompany";
    role: Role;
    email: string;
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    whiteLabelSettingsUid?: string | undefined;
}>;
export type AddAccountToCompany = z.infer<typeof AddAccountToCompanySchema>;
export declare const AddAccountToCompanyFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    whiteLabelSettingsUid?: string | undefined;
} & {
    role: Role;
    email: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.AddAccountToCompany";
    role: Role;
    email: string;
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    whiteLabelSettingsUid?: string | undefined;
}, {
    accountId: () => number;
}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.AddAccountToCompany">;
    email: z.ZodString;
    companyUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    role: z.ZodNativeEnum<typeof Role>;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
}, "strict", z.ZodTypeAny, {
    type: "Account.AddAccountToCompany";
    role: Role;
    email: string;
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    whiteLabelSettingsUid?: string | undefined;
}, {
    type: "Account.AddAccountToCompany";
    role: Role;
    email: string;
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    whiteLabelSettingsUid?: string | undefined;
}>>;
export declare const AddAccountToOrganization = "Account.AddAccountToOrganization";
export declare const AddAccountToOrganizationSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.AddAccountToOrganization">;
    email: z.ZodString;
    organizationUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    role: z.ZodNativeEnum<typeof Role>;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
}, "strict", z.ZodTypeAny, {
    type: "Account.AddAccountToOrganization";
    role: Role;
    email: string;
    accountId: number;
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    whiteLabelSettingsUid?: string | undefined;
}, {
    type: "Account.AddAccountToOrganization";
    role: Role;
    email: string;
    accountId: string | number;
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    whiteLabelSettingsUid?: string | undefined;
}>;
export type AddAccountToOrganization = z.infer<typeof AddAccountToOrganizationSchema>;
export declare const AddAccountToOrganizationFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    whiteLabelSettingsUid?: string | undefined;
} & {
    role: Role;
    email: string;
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.AddAccountToOrganization";
    role: Role;
    email: string;
    accountId: number;
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    whiteLabelSettingsUid?: string | undefined;
}, {
    accountId: () => number;
}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.AddAccountToOrganization">;
    email: z.ZodString;
    organizationUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    role: z.ZodNativeEnum<typeof Role>;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
}, "strict", z.ZodTypeAny, {
    type: "Account.AddAccountToOrganization";
    role: Role;
    email: string;
    accountId: number;
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    whiteLabelSettingsUid?: string | undefined;
}, {
    type: "Account.AddAccountToOrganization";
    role: Role;
    email: string;
    accountId: string | number;
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    whiteLabelSettingsUid?: string | undefined;
}>>;
export declare const ActivateAccount = "Account.ActivateAccount";
export declare const ActivateAccountSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.ActivateAccount">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
}, "strict", z.ZodTypeAny, {
    type: "Account.ActivateAccount";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.ActivateAccount";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type ActivateAccount = z.infer<typeof ActivateAccountSchema>;
export declare const ActivateAccountFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.ActivateAccount";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.ActivateAccount">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
}, "strict", z.ZodTypeAny, {
    type: "Account.ActivateAccount";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.ActivateAccount";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
/**
 * *.Settings.* is in the name due the legacy naming. And incorrect placement of this command.
 * So for backwards compatibility we need to keep it like this
 */
export declare const ChangeAccountFirstNameAndLastName = "Account.Settings.ChangeAccountFirstNameAndLastName";
export declare const ChangeAccountFirstNameAndLastNameSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Settings.ChangeAccountFirstNameAndLastName">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    firstname: z.ZodOptional<z.ZodEffects<z.ZodString, string, string>>;
    lastname: z.ZodOptional<z.ZodEffects<z.ZodString, string, string>>;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.ChangeAccountFirstNameAndLastName";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    firstname?: string | undefined;
    lastname?: string | undefined;
}, {
    type: "Account.Settings.ChangeAccountFirstNameAndLastName";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    firstname?: string | undefined;
    lastname?: string | undefined;
}>;
export type ChangeAccountFirstNameAndLastName = z.infer<typeof ChangeAccountFirstNameAndLastNameSchema>;
export declare const ChangeAccountFirstNameAndLastNameFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    firstname?: string | undefined;
    lastname?: string | undefined;
} & {
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.Settings.ChangeAccountFirstNameAndLastName";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    firstname?: string | undefined;
    lastname?: string | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Settings.ChangeAccountFirstNameAndLastName">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    firstname: z.ZodOptional<z.ZodEffects<z.ZodString, string, string>>;
    lastname: z.ZodOptional<z.ZodEffects<z.ZodString, string, string>>;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.ChangeAccountFirstNameAndLastName";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    firstname?: string | undefined;
    lastname?: string | undefined;
}, {
    type: "Account.Settings.ChangeAccountFirstNameAndLastName";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    firstname?: string | undefined;
    lastname?: string | undefined;
}>>;
export declare const AssignCompanyLicenseToAccount = "Account.AssignCompanyLicenseToAccount";
export declare const AssignCompanyLicenseToAccountSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.AssignCompanyLicenseToAccount">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    companyUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    license: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/License/License").License>;
}, "strict", z.ZodTypeAny, {
    type: "Account.AssignCompanyLicenseToAccount";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    license: import("@signageos/common-types/dist/License/License").License;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.AssignCompanyLicenseToAccount";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    license: import("@signageos/common-types/dist/License/License").License;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type AssignCompanyLicenseToAccount = z.infer<typeof AssignCompanyLicenseToAccountSchema>;
export declare const AssignCompanyLicenseToAccountFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    license: import("@signageos/common-types/dist/License/License").License;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.AssignCompanyLicenseToAccount";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    license: import("@signageos/common-types/dist/License/License").License;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.AssignCompanyLicenseToAccount">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    companyUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    license: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/License/License").License>;
}, "strict", z.ZodTypeAny, {
    type: "Account.AssignCompanyLicenseToAccount";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    license: import("@signageos/common-types/dist/License/License").License;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.AssignCompanyLicenseToAccount";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    license: import("@signageos/common-types/dist/License/License").License;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const UnassignCompanyLicenseFromAccount = "Account.UnassignCompanyLicenseFromAccount";
export declare const UnassignCompanyLicenseFromAccountSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.UnassignCompanyLicenseFromAccount">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    companyUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    license: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/License/License").License>;
}, "strict", z.ZodTypeAny, {
    type: "Account.UnassignCompanyLicenseFromAccount";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    license: import("@signageos/common-types/dist/License/License").License;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.UnassignCompanyLicenseFromAccount";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    license: import("@signageos/common-types/dist/License/License").License;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type UnassignCompanyLicenseFromAccount = z.infer<typeof UnassignCompanyLicenseFromAccountSchema>;
export declare const UnassignCompanyLicenseFromAccountFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    license: import("@signageos/common-types/dist/License/License").License;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.UnassignCompanyLicenseFromAccount";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    license: import("@signageos/common-types/dist/License/License").License;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.UnassignCompanyLicenseFromAccount">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    companyUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    license: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/License/License").License>;
}, "strict", z.ZodTypeAny, {
    type: "Account.UnassignCompanyLicenseFromAccount";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    license: import("@signageos/common-types/dist/License/License").License;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.UnassignCompanyLicenseFromAccount";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyUid: string;
    license: import("@signageos/common-types/dist/License/License").License;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
