"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RemoveAllAccountSessionsFactory = exports.RemoveAllAccountSessionsSchema = exports.RemoveAllAccountSessions = exports.RemoveAccountSessionFactory = exports.RemoveAccountSessionSchema = exports.RemoveAccountSession = exports.AddAccountSessionFactory = exports.AddAccountSessionSchema = exports.AddAccountSession = void 0;
const zod_1 = require("zod");
const commandFactory_1 = require("../../commandFactory");
const ICommand_1 = require("../../ICommand");
const accountCommands_1 = require("../accountCommands");
exports.AddAccountSession = 'Account.Session.AddAccountSession';
exports.AddAccountSessionSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.AddAccountSession),
    accountId: accountCommands_1.AccountIdSchema,
    sessionUid: zod_1.z.string(),
});
exports.AddAccountSessionFactory = (0, commandFactory_1.createCommandFactory)(exports.AddAccountSessionSchema);
exports.RemoveAccountSession = 'Account.Session.RemoveAccountSession';
exports.RemoveAccountSessionSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.RemoveAccountSession),
    accountId: accountCommands_1.AccountIdSchema,
    sessionUid: zod_1.z.string(),
});
exports.RemoveAccountSessionFactory = (0, commandFactory_1.createCommandFactory)(exports.RemoveAccountSessionSchema);
exports.RemoveAllAccountSessions = 'Account.Session.RemoveAllAccountSessions';
exports.RemoveAllAccountSessionsSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.RemoveAllAccountSessions),
    accountId: accountCommands_1.AccountIdSchema,
});
exports.RemoveAllAccountSessionsFactory = (0, commandFactory_1.createCommandFactory)(exports.RemoveAllAccountSessionsSchema);
//# sourceMappingURL=accountSessionCommands.js.map