import { TokenProvider } from './token-provider.js';
export class TokenProviderMiddleware {
    constructor(options) {
        var _a;
        if ('token' in options) {
            this.tokenProvider = {
                getAccessToken: () => Promise.resolve(options.token),
            };
        }
        else {
            this.tokenProvider = new TokenProvider({
                ...options,
                audience: (_a = options.audience) !== null && _a !== void 0 ? _a : `https://${options.domain}/api/v2/`,
                ...{ clientSecret: options.clientSecret },
                ...{
                    clientAssertionSigningKey: options
                        .clientAssertionSigningKey,
                },
            });
        }
    }
    async pre(context) {
        const token = await this.tokenProvider.getAccessToken();
        context.init.headers = {
            ...context.init.headers,
            Authorization: `Bearer ${token}`,
        };
        return {
            url: context.url,
            init: context.init,
        };
    }
}
//# sourceMappingURL=token-provider-middleware.js.map