import { IncomingHttpHeaders } from 'http';
export type Message = any;
export type Listener = (payload: any, reason?: string) => void;
export interface ICloseData {
    code: number;
    reason?: string;
}
export interface ISocket {
    /** The full hostname including protocol (scheme), host and port. Usually known as origin */
    hostname?: string;
    /** The full path including search part (query parameters) */
    path?: string;
    headers?: IncomingHttpHeaders;
    getDisconnectedPromise(): Promise<ICloseData>;
    bindError(listener: (error: Error) => void): () => void;
    bindMessage<TMessage>(event: string, listener: (payload: TMessage) => void): () => void;
    getMessagePromise<TMessage>(event: string): Promise<TMessage>;
    sendMessage(event: string, payload: any): Promise<void>;
    sendMessageExpectingResponse(event: string, payload: any): Promise<void>;
    disconnect(code?: number, reason?: string): Promise<void>;
    drain(): void;
}
export interface ISocketServer {
    bindConnection(listener: (socket: ISocket) => void): void;
}
export interface ISocketServerWrapper {
    server: ISocketServer;
    listen(): Promise<void>;
    close(): Promise<void>;
}
