"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSocketIOSocketServer = createSocketIOSocketServer;
const socket_io_1 = __importDefault(require("socket.io"));
const http_1 = require("../Utils/http");
function createSocketIOSocketServer(server, options = {}) {
    const socketio = (0, socket_io_1.default)(server, { pingInterval: 30e3, pingTimeout: 30e3, path: options.path });
    return {
        server: {
            bindConnection(serverListener) {
                socketio.on('connection', (socket) => serverListener({
                    getDisconnectedPromise() {
                        return new Promise((resolve) => {
                            socket.on('disconnect', (code, reason) => resolve({ code, reason }));
                        });
                    },
                    bindError(listener) {
                        socket.on('error', listener);
                        return () => socket.removeListener('error', listener);
                    },
                    bindMessage(event, listener) {
                        const messageListener = (payload, callback) => {
                            listener(payload);
                            if (callback) {
                                callback();
                            }
                        };
                        socket.on(event, messageListener);
                        return () => socket.removeListener(event, messageListener);
                    },
                    getMessagePromise(event) {
                        return new Promise((resolve) => {
                            socket.once(event, resolve);
                        });
                    },
                    sendMessage(event, message) {
                        return __awaiter(this, void 0, void 0, function* () {
                            socket.emit(event, message);
                        });
                    },
                    sendMessageExpectingResponse(event, message) {
                        return new Promise((resolve) => {
                            socket.emit(event, message, resolve);
                        });
                    },
                    disconnect(_code, _reason) {
                        return __awaiter(this, void 0, void 0, function* () {
                            socket.disconnect(true);
                        });
                    },
                    drain() {
                        socket.removeAllListeners();
                    },
                    hostname: (0, http_1.getHostnameFromRequestHeaders)(socket.request.headers),
                    path: socket.request.url,
                    headers: socket.request.headers,
                }));
            },
        },
        listen() {
            return __awaiter(this, void 0, void 0, function* () {
                // Automatically started
            });
        },
        close() {
            return __awaiter(this, void 0, void 0, function* () {
                // Nothing to do
            });
        },
    };
}
//# sourceMappingURL=socketIOServerFactory.js.map