import ISocket, { UndeliveredEmitError, IErrorEvent, UnconfirmedMessageError } from '../ISocket';
export default class AutoReconnectingWSSocket implements ISocket {
    private createSocket;
    private progressiveWait;
    private socket;
    private internalEventEmitter;
    private closed;
    private eventListeners;
    private emitsQueue;
    constructor(createSocket: (onConnected: () => void, onDisconnected: () => void, onError: (error: IErrorEvent | UnconfirmedMessageError | UndeliveredEmitError) => void) => ISocket, initialReconnectTimeout?: number, maxReconnectTimeout?: number);
    on(event: string, listener: (message: any) => void): void;
    once(event: string, listener: (message: any) => void): void;
    emit(event: string, message: any, callback?: () => void): void;
    removeListener(event: string, listener: (message: any) => void): void;
    removeAllListeners(): void;
    close(): void;
    onConnected(callback: () => void): void;
    onDisconnected(callback: () => void): void;
    onError(callback: (error: IErrorEvent | UnconfirmedMessageError | UndeliveredEmitError) => void): void;
    private openNewSocket;
    private onSocketConnected;
    private onSocketDisconnected;
    private registerOnceListenerOnCurrentSocket;
    private removeEventListenerFromList;
}
