"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.castEnum = void 0;
exports.getEnumFromString = getEnumFromString;
/**
 * @param e string enum from which to retrieve the value
 * @param value string which should be converted to enum value
 * @returns enum value or undefined if value is not in enum
 * @throws error if enum is numeric or heterogeneous
 */
function getEnumFromString(e, value) {
    const allValues = Object.values(e);
    const numericValues = Object.values(e).filter((v) => !isNaN(Number(v)));
    if (numericValues.length > 0) {
        throw Error('Enum has non-string values');
    }
    return allValues.includes(value) ? value : undefined;
}
/**
 * Safely casts `val` of enum type `U` to enum of type `T`, only if enums
 * overlap. This is only compile-time cast and it does not validate the value
 * during runtime.
 *
 * **`castEnum` only works for enums with string values**
 *
 * @example
 * enum AB { a = "A", b = "B" }
 * enum ABC { A = "A", B = "B", C = "C" }
 *
 * const x: AB = castEnum(ABC.B) // does work
 * const x: AB = castEnum(ABC.C) // does not work
 */
const castEnum = (val) => val;
exports.castEnum = castEnum;
//# sourceMappingURL=enum.js.map