"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.areArraysEqualIgnoreOrder = areArraysEqualIgnoreOrder;
exports.assertArraysEqualIgnoreOrder = assertArraysEqualIgnoreOrder;
const assert_1 = require("assert");
const lodash_1 = require("lodash");
function areArraysEqualIgnoreOrder(arr1, arr2, comparator = lodash_1.isEqual) {
    return (0, lodash_1.differenceWith)(arr1, arr2, comparator).length === 0 && (0, lodash_1.differenceWith)(arr2, arr1, comparator).length === 0;
}
function assertArraysEqualIgnoreOrder(arr1, arr2, comparator = lodash_1.isEqual) {
    if (!areArraysEqualIgnoreOrder(arr1, arr2, comparator)) {
        throw new assert_1.AssertionError({
            message: `Arrays are not equal`,
            expected: arr1,
            actual: arr2,
            operator: 'assertArraysEqualIgnoreOrder',
            stackStartFn: assertArraysEqualIgnoreOrder,
        });
    }
}
//# sourceMappingURL=array.js.map