"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = wait;
function wait(timeout, { signal } = {}) {
    let timer = undefined;
    let rejectCallback = null;
    const promise = new Promise((resolve, reject) => {
        rejectCallback = reject;
        timer = setTimeout(() => {
            rejectCallback = null;
            resolve();
        }, timeout);
    });
    promise.cancel = () => {
        if (timer) {
            clearTimeout(timer);
            timer = undefined;
            if (rejectCallback) {
                rejectCallback(new Error('Wait cancelled'));
            }
            rejectCallback = null;
        }
    };
    signal === null || signal === void 0 ? void 0 : signal.addEventListener('abort', () => promise.cancel());
    return promise;
}
//# sourceMappingURL=wait.js.map