export type IDeferred<T> = {
    promise: Promise<T>;
    resolve: (value: T) => void;
    reject: (error: Error) => void;
};
/**
 * It creates outside controlled promise so you can do the resole and reject outside the Promise constructor callback.
 * Similar to Promise.withResolvers(), but warns when resolved multiple times.
 *
 * @deprecated use createDeferred(true) if expected to be resolved once,
 * use lock() if no value and may be resolved multiple times,
 * use createDeferredStream() if expected to be resolved multiple times,
 */
export declare function createDeferred<T>(): IDeferred<T>;
/**
 * It creates outside controlled promise so you can do the resole and reject outside the Promise constructor callback.
 * Similar to Promise.withResolvers(), but throws when resolved multiple times.
 */
export declare function createDeferred<T>(throwIfResolvedMultipleTimes: boolean): IDeferred<T>;
