"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeObservables = mergeObservables;
exports.asyncMap = asyncMap;
exports.flatten = flatten;
function mergeObservables(...observables) {
    return new Observable((observer) => {
        const observings = observables.map((observable) => {
            let resolved = false;
            let resolve;
            const completePromise = new Promise((doResolve) => {
                if (resolved) {
                    doResolve();
                }
                else {
                    resolve = doResolve;
                }
            });
            const subscription = observable.subscribe((value) => observer.next(value), (error) => observer.error(error), () => (resolve ? resolve() : (resolved = true)));
            return {
                subscription,
                completePromise,
            };
        });
        Promise.all(observings.map((observing) => observing.completePromise)).then(() => observer.complete());
        return () => {
            observings.forEach((observing) => observing.subscription.unsubscribe());
        };
    });
}
function asyncMap(observable, mapCallback) {
    return new Observable((observer) => {
        const inputSubscription = observable.subscribe((inputValue) => __awaiter(this, void 0, void 0, function* () {
            try {
                const outputValue = yield mapCallback(inputValue);
                observer.next(outputValue);
            }
            catch (error) {
                observer.error(error);
            }
        }), (error) => observer.error(error), () => observer.complete());
        return () => {
            inputSubscription.unsubscribe();
        };
    });
}
function flatten(observable, depth = 1) {
    return new Observable((observer) => {
        const subscription = observable.subscribe((values) => __awaiter(this, void 0, void 0, function* () {
            for (const value of [values].flat(depth)) {
                observer.next(value);
            }
        }), (error) => observer.error(error), () => observer.complete());
        return () => {
            subscription.unsubscribe();
        };
    });
}
//# sourceMappingURL=helpers.js.map